<?php

namespace Database\Factories;

use App\Models\Receiver;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Receiver>
 */
class ReceiverFactory extends Factory
{
    protected $model = Receiver::class;
    public function definition(): array
    {
        return [
            'company_name' => $this->faker->company() . ' Distributors',
            'contact_person' => $this->faker->name(),
            'country' => $this->faker->country(),
            'phone_number' => $this->faker->phoneNumber(),
            'shipping_address' => $this->faker->address(),
        ];
    }
}
