<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payment extends Model
{
    use HasFactory, HasUuids;
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $fillable = [
        'amount',
        'currency',
        'due_date',
        'exchange_rate',
        'payment_date',
        'payment_method',
        'payment_status'
    ];
    public function order(): BelongsTo {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
