<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Client extends Model
{
    use HasFactory, HasUuids;

    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';

    protected $fillable = [
        'client_name',
        'country',
        'registration_number',
        'tax_id',
        'contact_person',
        'phone_number',
        'billing_address',
        'shipping_address',
    ];

    // Orders where this company is the buyer
    public function buyerOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'buyer_id');
    }

    // Orders where this company is the receiver
    public function receiverOrders(): HasMany
    {
        return $this->hasMany(Order::class, 'receiver_id');
    }
}
