<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Client;
use Illuminate\Support\Str;

class ClientSeeder extends Seeder
{
    public function run(): void
    {
        $clients = [
            [
                'id' => (string) Str::uuid(),
                'client_name' => 'Acme Corp',
                'country' => 'USA',
                'registration_number' => '123456789',
                'tax_id' => 'TAX123456',
                'contact_person' => 'John Doe',
                'phone_number' => '+1-555-1234',
                'billing_address' => '123 Acme St, New York, NY',
                'shipping_address' => '456 Acme Warehouse, New York, NY',
            ],
            [
                'id' => (string) Str::uuid(),
                'client_name' => 'Globex Ltd',
                'country' => 'UK',
                'registration_number' => '987654321',
                'tax_id' => 'TAX987654',
                'contact_person' => 'Jane Smith',
                'phone_number' => '+44-20-1234-5678',
                'billing_address' => '789 Globex Rd, London',
                'shipping_address' => '101 Globex Distribution, London',
            ],
            // Add more clients as needed
        ];

        foreach ($clients as $company) {
            Client::create($company);
        }
    }
}
