<?php

namespace Database\Factories;

use App\Models\Order;
use App\Models\Client;
use App\Models\Transport;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\Order>
 */
class OrderFactory extends Factory
{
    protected $model = Order::class;

    public function definition(): array
    {
        $statuses = ['pending', 'processing', 'shipped', 'delivered'];
        $date = $this->faker->dateTimeBetween('-30 days', 'now');
        $estimatedDelivery = $this->faker->dateTimeBetween($date, '+30 days');

        return [
            'buyer_id' => Client::factory(),
            'receiver_id' => Client::factory(),
            'transport_id' => Transport::factory(),
            'date' => $date,
            'status' => $this->faker->randomElement($statuses),
            'estimated_delivery_date' => $estimatedDelivery,
        ];
    }

    public function pending(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'pending',
        ]);
    }

    public function delivered(): static
    {
        return $this->state(fn (array $attributes) => [
            'status' => 'delivered',
        ]);
    }
}
