<?php

namespace Database\Seeders;

use App\Models\Batch;
use App\Models\Product;
use Carbon\Carbon;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Str;

class BatchSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $products = Product::all();
        $counter = 1;

        foreach ($products as $product) {
            $batchCounter = rand(2,4);

            for ($i = 0; $i < $batchCounter; $i++) {
                $productionDate = Carbon::now()->subDays(rand(30, 100));
                $expirationDate = $productionDate->copy()->addYears(2);

                Batch::create([
                    'id' => Str::uuid(),
                    'product_id' => $product->id,
                    'batch_code' => 'BATCH-' . str_pad($counter, 6, '0', STR_PAD_LEFT),
                    'production_date' => $productionDate,
                    'expiration_date' => $expirationDate,
                    'net_weight' => rand(500, 5000) / 100,
                    'gross_weight' => rand(600, 6000) / 100,
                    'units_per_batch' => rand (10000, 100000),
                ]);

                $counter++;
            }
        }
    }
}
