<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Payment extends Model
{
    use HasUuids;
    protected $primaryKey = 'id';
    public $incrementing = false;
    protected $keyType = 'string';
    protected $fillable = [
        'order_id',
        'amount',
        'currency',
        'due_date',
        'exchange_rate',
        'payment_date',
        'payment_method',
        'payment_status'
    ];

    public static function getValidationRules($id = null): array
    {
        return [
            'order_id' => 'required|string|exists:orders,id',
            'amount' => 'required|numeric|min:0|max:9999999.99',
            'currency' => 'required|string|size:3|in:USD,EUR,MKD,GBP,JPY,CNY,RUB',
            'due_date' => 'required|date|after_or_equal:today',
            'exchange_rate' => 'required|numeric|min:0.0001|max:9999.9999',
            'payment_date' => 'required|date|before_or_equal:today',
            'payment_method' => 'required|string|in:bank_transfer,credit_card,cash,check,wire_transfer',
            'payment_status' => 'required|string|in:pending,paid,failed,refunded,cancelled',
        ];
    }
    public function order(): BelongsTo {
        return $this->belongsTo(Order::class, 'order_id');
    }
}
