<?php
namespace Database\Seeders;

use App\Models\Invoice;
use App\Models\Order;
use Carbon\Carbon;
use Illuminate\Database\Seeder;

class InvoiceSeeder extends Seeder
{
    private array $statuses = ['draft', 'sent', 'paid', 'overdue', 'cancelled'];

    public function run(): void
    {
        $orders = Order::all();

        foreach ($orders as $order) {
            // Create an invoice for about 80% of orders
            if (rand(1, 100) <= 80) {
                $invoiceDate = Carbon::parse($order->date)->addDays(rand(0, 7)); // Fixed: Use Carbon::parse()

                Invoice::create([
                    'invoice_date' => $invoiceDate,
                    'status' => $this->statuses[array_rand($this->statuses)],
                    'total_amount' => $order->total_amount,
                    'order_id' => $order->id,
                ]);
            }
        }
    }
}
