<?php
namespace Database\Seeders;

use App\Models\PackingList;
use App\Models\Order;
use Illuminate\Database\Seeder;
use Carbon\Carbon;

class PackingListSeeder extends Seeder
{
    private $statuses = ['draft', 'prepared', 'packed', 'shipped'];

    public function run(): void
    {
        $orders = Order::whereIn('status', ['processing', 'shipped', 'delivered'])->get();

        foreach ($orders as $order) {
            // Create a packing list for shipped/delivered orders
            if (in_array($order->status, ['shipped', 'delivered']) || rand(1, 100) <= 60) {
                $packingListDate = Carbon::parse($order->date)->addDays(rand(1, 5)); // Fixed: Use Carbon::parse()

                PackingList::create([
                    'order_id' => $order->id,
                    'packing_list_date' => $packingListDate,
                    'status' => $this->statuses[array_rand($this->statuses)],
                ]);
            }
        }
    }
}
