package mk.profesori.springapp.Controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.annotation.CurrentSecurityContext;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.web.bind.annotation.CrossOrigin;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import com.fasterxml.jackson.databind.node.ObjectNode;

import mk.profesori.springapp.Model.CustomUserDetails;
import mk.profesori.springapp.Service.MainService;

@RestController
@RequestMapping("/secure")
@CrossOrigin(origins = { "http://192.168.0.17:3000", "http://192.168.0.24:3000" })
public class SecureController {

    @Autowired
    private MainService mainService;

    @RequestMapping(value = "/professor/{professorId}/addOpinion", method = RequestMethod.POST)
    public void addOpinion(@RequestBody ObjectNode objectNode, @PathVariable Long professorId,
            @CurrentSecurityContext SecurityContext context) {

        Authentication authentication = context.getAuthentication();

        if (authentication != null && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails currentUser = (CustomUserDetails) authentication.getPrincipal();
            String title = objectNode.get("title").asText();
            String content = objectNode.get("content").asText();
            mainService.addOpinion(title, content, professorId, currentUser);
        }
    }

    @RequestMapping(value = "/professor/{professorId}/replyToOpinion/{postId}", method = RequestMethod.POST)
    public void replyToOpinion(@RequestBody ObjectNode objectNode, @PathVariable Long professorId,
            @PathVariable Long postId, @CurrentSecurityContext SecurityContext context) {

        Authentication authentication = context.getAuthentication();

        if (authentication != null && authentication.getPrincipal() instanceof CustomUserDetails) {
            CustomUserDetails currentUser = (CustomUserDetails) authentication.getPrincipal();
            String content = objectNode.get("content").asText();
            mainService.replyToOpinion(content, professorId, postId, currentUser);
        }
    }

}
