import React, {useEffect, useState} from 'react';
import {Checkbox, Input, List} from "antd";
import moment from "moment";
import axios from "axios";
import env from "../env";

const Vip = (props) =>{

    const [loading,setLoading] = useState(true);
    const [users,setUsers] = useState([]);

    const getData = () =>{
        axios.get(env.api + 'Users', {
            headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            console.log(res.data)
            setUsers(res.data.sort(x => x.id));
            setLoading(false);
        });
    }

    useEffect(()=>{
        getData()
    },[])

    const updateVip = (id, val) => {
        console.log(val.target.checked)
        setLoading(true)
        axios.post(env.api + 'Users/'+id+'/vip', {},{
            params: {newStatus: val.target.checked},
            headers: {Authorization: localStorage.getItem('Auth')}
        }).then(res => {
            getData()
            setLoading(false);
        });
    }


    return(
        <div style={{padding:'20px'}}>
            <div style={{
                width: '100%',
                height:'75px',
                backgroundColor: 'white',
                padding: '20px',
                border: '1px solid lightgray'
            }} >
                <h2 style={{float: 'left'}}>VIP корисници</h2>
            </div>
            <div style={{backgroundColor:'white'}}>
            <List loading={loading} dataSource={users} itemLayout={'horizontal'} locale={{emptyText:'Нема корисници'}}
                  renderItem={item => (
                      <List.Item
                          actions={[<Checkbox checked={item.isVip} onChange={(val)=>updateVip(item.id,val)}>Вип корисник</Checkbox>]}>
                          <div style={{display:'flex',flexDirection:'row',justifyContent:'space-between',width:'100%', padding:'10px'}}>
                              <span>{item.id}</span>
                              <span>{item.email}</span>
                          </div>
                      </List.Item>
                  )}/>
            </div>
        </div>
    )
}

export default Vip;