<?php

namespace Database\Seeders;

use App\Models\Subject;
use Illuminate\Database\Seeder;

class SubjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subjects = [
            // Year 1 - Winter Semester
            [
                'code' => 'F23L1W001',
                'name' => 'Structured Programming',
                'name_mk' => 'Структурирано програмирање',
                'description' => 'Introduction to programming concepts and C language',
                'description_mk' => 'Вовед во концепти на програмирање и C јазик',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W002',
                'name' => 'Calculus I',
                'name_mk' => 'Анализа I',
                'description' => 'Limits, derivatives, and integration',
                'description_mk' => 'Граници, дериватни и интеграли',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W003',
                'name' => 'Discrete Mathematics',
                'name_mk' => 'Дискретна математика',
                'description' => 'Logic, sets, combinatorics, graph theory',
                'description_mk' => 'Логика, множества, комбинаторика, теорија на графови',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 1 - Summer Semester
            [
                'code' => 'F23L1S001',
                'name' => 'Calculus II',
                'name_mk' => 'Анализа II',
                'description' => 'Advanced calculus and series',
                'description_mk' => 'Напредна анализа и серии',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S002',
                'name' => 'Linear Algebra',
                'name_mk' => 'Линеарна алгебра',
                'description' => 'Vectors, matrices, eigenvalues',
                'description_mk' => 'Вектори, матрици, карактеристични вредности',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S003',
                'name' => 'Physics I',
                'name_mk' => 'Физика I',
                'description' => 'Mechanics and thermodynamics',
                'description_mk' => 'Механика и термодинамика',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 2 - Winter Semester
            [
                'code' => 'F23L2W001',
                'name' => 'Algorithms and Data Structures',
                'name_mk' => 'Алгоритми и податочни структури',
                'description' => 'Fundamental data structures and algorithm design',
                'description_mk' => 'Основни структури и дизајн на алгоритми',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W002',
                'name' => 'Object-Oriented Programming',
                'name_mk' => 'Објектно-ориентирано програмирање',
                'description' => 'Classes, inheritance, polymorphism in C++/Java',
                'description_mk' => 'Класи, наследување, полиморфизам во C++/Java',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W003',
                'name' => 'Digital Logic',
                'name_mk' => 'Дигитална логика',
                'description' => 'Boolean algebra, combinational and sequential circuits',
                'description_mk' => 'Булова алгебра, комбинаторни и секвенцијални кола',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 2 - Summer Semester
            [
                'code' => 'F23L2S001',
                'name' => 'Web Programming',
                'name_mk' => 'Веб програмирање',
                'description' => 'HTML, CSS, JavaScript, and web frameworks',
                'description_mk' => 'HTML, CSS, JavaScript, и веб фремворци',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S002',
                'name' => 'Databases I',
                'name_mk' => 'Бази на податоци I',
                'description' => 'Relational model, SQL, database design',
                'description_mk' => 'Релационален модел, SQL, дизајн на БП',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S003',
                'name' => 'Computer Architecture',
                'name_mk' => 'Архитектура на компјутери',
                'description' => 'CPU design, memory hierarchy, assembly language',
                'description_mk' => 'Дизајн на CPU, хиерархија на меморија, асемблер',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 3 - Winter Semester
            [
                'code' => 'F23L3W001',
                'name' => 'Operating Systems',
                'name_mk' => 'Оперативни системи',
                'description' => 'Processes, memory management, file systems',
                'description_mk' => 'Процеси, управување со меморија, датотечни системи',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W002',
                'name' => 'Computer Networks',
                'name_mk' => 'Компјутерски мрежи',
                'description' => 'TCP/IP, routing, network protocols',
                'description_mk' => 'TCP/IP, рутирање, мрежни протоколи',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W003',
                'name' => 'Software Engineering',
                'name_mk' => 'Софтверско инженерство',
                'description' => 'SDLC, design patterns, testing, project management',
                'description_mk' => 'SDLC, шаблони на дизајн, тестирање, менаџмент',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 3 - Summer Semester
            [
                'code' => 'F23L3S001',
                'name' => 'Cybersecurity',
                'name_mk' => 'Кибербезбедност',
                'description' => 'Encryption, authentication, network security',
                'description_mk' => 'Енкрипција, автентификација, мрежна безбедност',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S002',
                'name' => 'Artificial Intelligence',
                'name_mk' => 'Вештачка интелигенција',
                'description' => 'Search algorithms, machine learning basics',
                'description_mk' => 'Алгоритми за пребарување, основи на машинско учење',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S003',
                'name' => 'Computer Graphics',
                'name_mk' => 'Компјутерска графика',
                'description' => '3D graphics, rendering, shaders',
                'description_mk' => '3D графика, рендерирање, шејдери',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],

            // Year 4 (Only for 4-year programs)
            [
                'code' => 'F23L4W001',
                'name' => 'Advanced Databases',
                'name_mk' => 'Напредни бази на податоци',
                'description' => 'Advanced SQL, transactions, optimization',
                'description_mk' => 'Напредна SQL, транзакции, оптимизација',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4W002',
                'name' => 'Machine Learning',
                'name_mk' => 'Машинско учење',
                'description' => 'Classification, regression, neural networks',
                'description_mk' => 'Класификација, регресија, невронски мрежи',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4S001',
                'name' => 'Cloud Computing',
                'name_mk' => 'Облачни компјутери',
                'description' => 'AWS, Azure, GCP, containerization',
                'description_mk' => 'AWS, Azure, GCP, контејнеризација',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4S002',
                'name' => 'Capstone Project',
                'name_mk' => 'Завршен проект',
                'description' => 'Apply learned skills to a real-world project',
                'description_mk' => 'Примена на научени вештини во реален проект',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 0,
                'practice_hours' => 180,
            ],
        ];

        foreach ($subjects as $subject) {
            Subject::create($subject);
        }
    }
}
