<?php

namespace Database\Seeders;

use App\Models\StudyProgram;
use App\Models\Subject;
use Illuminate\Database\Seeder;

class AssignSubjectsToStudyProgramsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     * Assigns subjects to study programs based on curriculum data.
     */
    public function run(): void
    {
        $assignments = [
            'Софтверско инженерство и информациски системи' => [
                ['F23L1W005' => 'mandatory'],
                ['F23L1W007' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F18L1S003' => 'mandatory'],
                ['F23L1W003' => 'mandatory'],
                ['F23L2S015' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F23L1W004' => 'mandatory'],
                ['F18L1S034' => 'elective'],
                ['F23L1S116' => 'elective'],
                ['F23L1S120' => 'elective'],
                ['F18L1S146' => 'elective'],
                ['F18L1S066' => 'elective'],
                ['F23L2W001' => 'mandatory'],
                ['F23L2W014' => 'mandatory'],
                ['F18L2S100' => 'elective'],
                ['F18L2W109' => 'elective'],
                ['F23L3W140' => 'elective'],
                ['F18L2W165' => 'elective'],
                ['F18L2S002' => 'mandatory'],
                ['F23L3W001' => 'mandatory'],
                ['F23L2S061' => 'elective'],
                ['F23L3S002' => 'elective'],
                ['F23L2S082' => 'elective'],
                ['F23L2S084' => 'elective'],
                ['F23L2S090' => 'elective'],
                ['F23L2S095' => 'elective'],
                ['F23L2S042' => 'elective'],
                ['F18L2S110' => 'elective'],
                ['F23L3S003' => 'elective'],
                ['F18L2S119' => 'elective'],
                ['F18L2S124' => 'elective'],
                ['F23L3W004' => 'mandatory'],
                ['F23L3W008' => 'mandatory'],
                ['F23L3W009' => 'mandatory'],
                ['F18L3W060' => 'elective'],
                ['F23L2S001' => 'elective'],
                ['F18L3W081' => 'elective'],
                ['F18L3W043' => 'elective'],
                ['F18L3W115' => 'elective'],
                ['CSEW522' => 'elective'],
                ['F18L3W148' => 'elective'],
                ['F23L3S010' => 'mandatory'],
                ['F23L3S012' => 'mandatory'],
                ['F23L3S019' => 'mandatory'],
                ['F18L3S077' => 'elective'],
                ['F18L3S118' => 'elective'],
                ['F23L4W002' => 'elective'],
                ['F18L3S155' => 'elective'],
                ['F18L3S163' => 'elective'],
                ['F23L3W021' => 'mandatory'],
                ['F18L3W085' => 'elective'],
                ['F18L3W089' => 'elective'],
                ['F18L3W103' => 'elective'],
                ['F18L3W027' => 'elective'],
                ['F18L3W126' => 'elective'],
                ['F18L3W128' => 'elective'],
                ['F18L3W137' => 'elective'],
                ['F18L3W038' => 'elective'],
                ['F18L3W154' => 'elective'],
                ['F18L3W161' => 'elective'],
                ['F23L3S168' => 'mandatory'],
                ['F23L3S022' => 'mandatory'],
                ['F18L3S078' => 'elective'],
                ['F18L3S080' => 'elective'],
                ['F18L3S083' => 'elective'],
                ['F18L3S086' => 'elective'],
                ['F18L3S102' => 'elective'],
                ['F18L3S132' => 'elective'],
                ['F23L4W001' => 'elective'],
                ['F18L3S141' => 'elective'],
                ['F23L3S028' => 'elective'],
                ['F18L3S162' => 'elective'],
                ['F18L1W005' => 'mandatory'],
                ['F18L1S013' => 'mandatory'],
                ['F18L1S016' => 'mandatory'],
                ['F18L1S116' => 'elective'],
                ['F18L1S026' => 'elective'],
                ['F18L1S120' => 'elective'],
                ['F18L2W014' => 'mandatory'],
                ['F18L2W006' => 'mandatory'],
                ['F18L2W167' => 'elective'],
                ['F18L2W104' => 'elective'],
                ['F18L2S017' => 'mandatory'],
                ['F18L2S097' => 'elective'],
                ['F18L2S114' => 'elective'],
                ['F18L2S099' => 'elective'],
                ['F18L2S042' => 'elective'],
                ['F18L2S164' => 'elective'],
                ['F18L3S084' => 'elective'],
                ['F18L2S061' => 'elective'],
                ['F18L3W009' => 'mandatory'],
                ['F18L3W136' => 'elective'],
                ['F18L3W053' => 'elective'],
                ['F18L3W035' => 'elective'],
                ['F18L3W134' => 'elective'],
                ['F18L3S010' => 'mandatory'],
                ['F18L3S073' => 'elective'],
                ['F18L3S150' => 'elective'],
                ['F18L3S093' => 'elective'],
                ['F18L3S025' => 'elective'],
                ['F18L3S040' => 'elective'],
                ['F18L3S039' => 'elective'],
                ['F18L3S091' => 'elective'],
                ['F18L3S087' => 'elective'],
                ['F18L3S036' => 'elective'],
                ['F18L3S135' => 'elective'],
                ['F18L3S149' => 'elective'],
                ['F18L3S047' => 'elective'],
                ['F18L3S159' => 'elective'],
                ['F18L3S062' => 'elective'],
                ['F18L3W072' => 'elective'],
                ['F18L3W068' => 'elective'],
                ['F18L3W074' => 'elective'],
                ['F18L3W156' => 'elective'],
                ['F18L3W092' => 'elective'],
                ['F18L3W075' => 'elective'],
                ['F18L3W105' => 'elective'],
                ['F18W3S085' => 'elective'],
                ['F18L3W088' => 'elective'],
                ['F18L3W108' => 'elective'],
                ['F18L3W123' => 'elective'],
                ['F18L3W129' => 'elective'],
                ['F18L3W142' => 'elective'],
                ['F18L3W144' => 'elective'],
                ['F18L3W160' => 'elective'],
                ['F18L3W048' => 'elective'],
                ['F18L3W152' => 'elective'],
                ['F18L3W079' => 'elective'],
                ['F18L3S121' => 'elective'],
                ['F18L3S130' => 'elective'],
                ['F18L3S113' => 'elective'],
                ['F18L3S157' => 'elective'],
                ['F18L3S028' => 'elective'],
                ['F18L3S106' => 'elective'],
                ['F18L3S107' => 'elective'],
                ['F18L3S127' => 'elective'],
                ['F23L1W004' => 'mandatory'],
                ['F23L1W005' => 'mandatory'],
                ['F23L1W007' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F23L1S003' => 'mandatory'],
                ['F23L1S016' => 'mandatory'],
                ['F23L2S001' => 'mandatory'],
                ['F23L2S015' => 'mandatory'],
                ['F23L2W001' => 'mandatory'],
                ['F23L2W014' => 'mandatory'],
                ['F23L3W001' => 'mandatory'],
                ['F23L2S002' => 'mandatory'],
                ['F23L2S017' => 'mandatory'],
                ['F23L2S030' => 'mandatory'],
                ['F23L3S100' => 'mandatory'],
                ['F23L3W004' => 'mandatory'],
                ['F23L3W008' => 'mandatory'],
                ['F23L3W009' => 'mandatory'],
                ['F23L3W140' => 'mandatory'],
                ['F23L3S010' => 'mandatory'],
                ['F23L3S012' => 'mandatory'],
                ['F23L3S019' => 'mandatory'],
                ['F23L3S138' => 'mandatory'],
                ['F23L3W021' => 'mandatory'],
                ['F23L3S022' => 'mandatory'],
                ['F23L3S028' => 'mandatory'],
                ['F23L3S168' => 'mandatory'],
                ['F23L1S052' => 'mandatory'],
                ['F23L1S116' => 'mandatory'],
                ['F23L1S120' => 'mandatory'],
                ['F23L1S146' => 'mandatory'],
                ['F23L2S066' => 'mandatory'],
                ['F23L1S026' => 'mandatory'],
                ['F23L2S042' => 'mandatory'],
                ['F23L2S051' => 'mandatory'],
                ['F23L2S061' => 'mandatory'],
                ['F23L2S082' => 'mandatory'],
                ['F23L2S084' => 'mandatory'],
                ['F23L2S090' => 'mandatory'],
                ['F23L2S095' => 'mandatory'],
            ],
            'Интернет, мрежи и безбедност' => [
                ['F23L1W005' => 'mandatory'],
                ['F23L1W007' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F23L1W003' => 'mandatory'],
                ['F18L1S045' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F18L1S066' => 'mandatory'],
                ['F23L1W004' => 'mandatory'],
                ['F18L1S023' => 'elective'],
                ['F18L1S034' => 'elective'],
                ['F23L1S116' => 'elective'],
                ['F23L1S120' => 'elective'],
                ['F23L2S015' => 'elective'],
                ['F18L1S146' => 'elective'],
                ['F23L2W001' => 'mandatory'],
                ['F23L3W002' => 'mandatory'],
                ['F18L2W067' => 'mandatory'],
                ['F18L2W109' => 'elective'],
                ['F23L3W140' => 'elective'],
                ['F18L2W147' => 'elective'],
                ['F18L2W165' => 'elective'],
                ['F23L2S061' => 'mandatory'],
                ['F23L3W001' => 'mandatory'],
                ['F23L3S002' => 'elective'],
                ['F23L2S082' => 'elective'],
                ['F23L2S084' => 'elective'],
                ['F23L2S090' => 'elective'],
                ['F18L2S110' => 'elective'],
                ['F18L2S124' => 'elective'],
                ['F23L3W003' => 'elective'],
                ['F18L3W060' => 'mandatory'],
                ['F23L3W004' => 'mandatory'],
                ['F18L3W065' => 'mandatory'],
                ['F23L2S001' => 'elective'],
                ['F18L3W081' => 'elective'],
                ['F23L3W008' => 'elective'],
                ['F18L3W043' => 'elective'],
                ['F18L3W115' => 'elective'],
                ['F18L3W148' => 'elective'],
                ['F18L3W037' => 'elective'],
                ['F18L3S059' => 'mandatory'],
                ['F18L3S077' => 'elective'],
                ['F23L3S010' => 'elective'],
                ['F18L3S111' => 'elective'],
                ['F18L3S118' => 'elective'],
                ['F18L3S122' => 'elective'],
                ['F18L3S125' => 'elective'],
                ['F18L3S155' => 'elective'],
                ['F18L3W064' => 'mandatory'],
                ['F18L3W085' => 'elective'],
                ['F18L3W098' => 'elective'],
                ['F18L3W103' => 'elective'],
                ['F18L3W126' => 'elective'],
                ['F18L3W128' => 'elective'],
                ['F18L3W133' => 'elective'],
                ['F18L3W145' => 'elective'],
                ['F23L3S168' => 'mandatory'],
                ['F18L3S063' => 'mandatory'],
                ['F18L3S080' => 'elective'],
                ['F18L3S101' => 'elective'],
                ['F18L3S132' => 'elective'],
                ['F23L4W001' => 'elective'],
                ['F18L3S141' => 'elective'],
                ['F23L3S028' => 'elective'],
                ['F18L3S162' => 'elective'],
                ['F23L3S022' => 'elective'],
            ],
            'Примена на информациски технологии' => [
                ['F23L1W005' => 'mandatory'],
                ['F23L1W007' => 'mandatory'],
                ['F23L1W003' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F18L1S003' => 'mandatory'],
                ['F18L1S023' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F23L1W004' => 'mandatory'],
                ['F18L1S052' => 'elective'],
                ['F18L1S034' => 'elective'],
                ['F23L1S116' => 'elective'],
                ['F23L1S120' => 'elective'],
                ['F23L2S015' => 'elective'],
                ['F18L1S146' => 'elective'],
                ['F23L2W001' => 'mandatory'],
                ['F23L2W014' => 'mandatory'],
                ['F18L2W096' => 'elective'],
                ['F18L2S100' => 'elective'],
                ['F18L2W109' => 'elective'],
                ['F23L3W140' => 'elective'],
                ['F18L2W165' => 'elective'],
                ['F23L3W001' => 'mandatory'],
                ['F23L3W003' => 'mandatory'],
                ['F18L2S002' => 'elective'],
                ['F23L2S061' => 'elective'],
                ['F23L3S002' => 'elective'],
                ['F23L2S082' => 'elective'],
                ['F23L2S084' => 'elective'],
                ['F23L2S090' => 'elective'],
                ['F23L2S042' => 'elective'],
                ['F18L2S110' => 'elective'],
                ['F23L3S003' => 'elective'],
                ['F18L2S119' => 'elective'],
                ['F18L2S124' => 'elective'],
                ['F23L3W004' => 'mandatory'],
                ['F23L2S001' => 'mandatory'],
                ['F23L3W008' => 'mandatory'],
                ['F18L3W060' => 'elective'],
                ['F18L3W081' => 'elective'],
                ['F23L3W009' => 'elective'],
                ['F18L3W043' => 'elective'],
                ['F18L3W115' => 'elective'],
                ['CSEW522' => 'elective'],
                ['F18L3W148' => 'elective'],
                ['F23L3S010' => 'mandatory'],
                ['F18L3S077' => 'elective'],
                ['F23L3S012' => 'elective'],
                ['F18L3S118' => 'elective'],
                ['F23L4W002' => 'elective'],
                ['F18L3S155' => 'elective'],
                ['F23L3S019' => 'elective'],
                ['F18L3W027' => 'mandatory'],
                ['F23L3W021' => 'mandatory'],
                ['F18L3W085' => 'elective'],
                ['F18L3W089' => 'elective'],
                ['F18L3W103' => 'elective'],
                ['F18L3W126' => 'elective'],
                ['F18L3W128' => 'elective'],
                ['F18L3W137' => 'elective'],
                ['F18L3W038' => 'elective'],
                ['F18L3W161' => 'elective'],
                ['F23L3S168' => 'mandatory'],
                ['F23L3S028' => 'mandatory'],
                ['F23L3S022' => 'mandatory'],
                ['F18L3S078' => 'elective'],
                ['F18L3S080' => 'elective'],
                ['F18L3S086' => 'elective'],
                ['F18L3S102' => 'elective'],
                ['F18L3S132' => 'elective'],
                ['F23L4W001' => 'elective'],
                ['F18L3S141' => 'elective'],
                ['F18L3S162' => 'elective'],
            ],
            'Компјутерско инженерство' => [
                ['F18L1W041' => 'mandatory'],
                ['F18L1W033' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F18L1W049' => 'mandatory'],
                ['F23L1W003' => 'mandatory'],
                ['F18L1S034' => 'mandatory'],
                ['F18L1S045' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F23L1W004' => 'mandatory'],
                ['F23L1S116' => 'elective'],
                ['F23L1S120' => 'elective'],
                ['F23L2S015' => 'elective'],
                ['F18L1S146' => 'elective'],
                ['F18L1S066' => 'elective'],
                ['F23L2W001' => 'mandatory'],
                ['F23L3W002' => 'mandatory'],
                ['F18L2W109' => 'elective'],
                ['F23L3W140' => 'elective'],
                ['F18L2W147' => 'elective'],
                ['F18L2W165' => 'elective'],
                ['F23L2S042' => 'mandatory'],
                ['F23L3W001' => 'mandatory'],
                ['F23L3W003' => 'mandatory'],
                ['F18L2S002' => 'elective'],
                ['F23L2S061' => 'elective'],
                ['F23L3S002' => 'elective'],
                ['F23L2S082' => 'elective'],
                ['F23L2S084' => 'elective'],
                ['F23L2S090' => 'elective'],
                ['F23L2S095' => 'elective'],
                ['F18L2S110' => 'elective'],
                ['F23L3S003' => 'elective'],
                ['F18L2S124' => 'elective'],
                ['F23L3W004' => 'mandatory'],
                ['F18L3W043' => 'mandatory'],
                ['F18L3W044' => 'mandatory'],
                ['F18L3W060' => 'elective'],
                ['F23L2S001' => 'elective'],
                ['F18L3W081' => 'elective'],
                ['F23L3W008' => 'elective'],
                ['F23L3W009' => 'elective'],
                ['F18L3W115' => 'elective'],
                ['F18L3W065' => 'elective'],
                ['CSEW522' => 'elective'],
                ['F18L3W148' => 'elective'],
                ['F18L3W037' => 'elective'],
                ['F18L3S059' => 'elective'],
                ['F18L3S077' => 'elective'],
                ['F23L3S010' => 'elective'],
                ['F23L3S012' => 'elective'],
                ['F18L3S118' => 'elective'],
                ['F18L3S122' => 'elective'],
                ['F23L4W002' => 'elective'],
                ['F18L3S125' => 'elective'],
                ['F18L3S153' => 'elective'],
                ['F18L3S155' => 'elective'],
                ['F18L3S158' => 'elective'],
                ['F23L3S019' => 'elective'],
                ['F18L3S163' => 'elective'],
                ['F18L3W085' => 'elective'],
                ['F18L3W089' => 'elective'],
                ['F18L3W064' => 'elective'],
                ['F18L3W098' => 'elective'],
                ['F18L3W103' => 'elective'],
                ['F18L3W117' => 'elective'],
                ['F18L3W027' => 'elective'],
                ['F18L3W126' => 'elective'],
                ['F18L3W128' => 'elective'],
                ['F18L3W131' => 'elective'],
                ['F18L3W133' => 'elective'],
                ['F18L3W137' => 'elective'],
                ['F18L3W145' => 'elective'],
                ['F18L3W038' => 'elective'],
                ['F18L3W161' => 'elective'],
                ['F23L3S168' => 'mandatory'],
                ['F23L3S022' => 'mandatory'],
                ['F18L3S078' => 'elective'],
                ['F18L3S080' => 'elective'],
                ['F18L3S083' => 'elective'],
                ['F18L3S086' => 'elective'],
                ['F18L3S063' => 'elective'],
                ['F18L3S101' => 'elective'],
                ['F18L3S132' => 'elective'],
                ['F23L4W001' => 'elective'],
                ['F18L3S141' => 'elective'],
                ['F23L3S028' => 'elective'],
                ['F18L3S162' => 'elective'],
            ],
            'Компјутерски науки' => [
                ['F23L1W007' => 'mandatory'],
                ['F18L1W031' => 'mandatory'],
                ['F18L1W033' => 'mandatory'],
                ['F23L1W018' => 'mandatory'],
                ['F23L1W020' => 'mandatory'],
                ['F18L1S003' => 'mandatory'],
                ['F18L1S032' => 'mandatory'],
                ['F18L1S034' => 'mandatory'],
                ['F23L2W002' => 'mandatory'],
                ['F23L1W004' => 'mandatory'],
                ['F23L1S116' => 'elective'],
                ['F23L1S120' => 'elective'],
                ['F23L2S015' => 'elective'],
                ['F18L1S146' => 'elective'],
                ['F23L2W001' => 'mandatory'],
                ['F23L2W014' => 'mandatory'],
                ['F18L2W109' => 'elective'],
                ['F23L3W140' => 'elective'],
                ['F18L2W165' => 'elective'],
                ['F23L3S002' => 'mandatory'],
                ['F23L3W001' => 'mandatory'],
                ['F23L3W003' => 'mandatory'],
                ['F18L2S002' => 'elective'],
                ['F23L2S061' => 'elective'],
                ['F23L2S082' => 'elective'],
                ['F23L2S084' => 'elective'],
                ['F23L2S090' => 'elective'],
                ['F23L2S095' => 'elective'],
                ['F23L2S042' => 'elective'],
                ['F18L2S110' => 'elective'],
                ['F23L3S003' => 'elective'],
                ['F18L2S124' => 'elective'],
                ['F23L3W004' => 'mandatory'],
                ['F18L3W037' => 'mandatory'],
                ['F18L3W060' => 'elective'],
                ['F23L2S001' => 'elective'],
                ['F18L3W081' => 'elective'],
                ['F23L3W008' => 'elective'],
                ['F23L3W009' => 'elective'],
                ['F18L3W043' => 'elective'],
                ['F18L3W115' => 'elective'],
                ['F18L3W065' => 'elective'],
                ['CSEW522' => 'elective'],
                ['F18L3W148' => 'elective'],
                ['F23L3S010' => 'mandatory'],
                ['F23L4W002' => 'mandatory'],
                ['F18L3S059' => 'elective'],
                ['F18L3S077' => 'elective'],
                ['F23L3S012' => 'elective'],
                ['F18L3S118' => 'elective'],
                ['F18L3S122' => 'elective'],
                ['F18L3S125' => 'elective'],
                ['F18L3S153' => 'elective'],
                ['F18L3S155' => 'elective'],
                ['F18L3S158' => 'elective'],
                ['F23L3S019' => 'elective'],
                ['F18L3S163' => 'elective'],
                ['F18L3W038' => 'mandatory'],
                ['F18L3W076' => 'elective'],
                ['F18L3W085' => 'elective'],
                ['F18L3W089' => 'elective'],
                ['F18L3W064' => 'elective'],
                ['F18L3W103' => 'elective'],
                ['F18L3W027' => 'elective'],
                ['F18L3W126' => 'elective'],
                ['F18L3W128' => 'elective'],
                ['F18L3W131' => 'elective'],
                ['F18L3W137' => 'elective'],
                ['F18L3W145' => 'elective'],
                ['F18L3W154' => 'elective'],
                ['F18L3W161' => 'elective'],
                ['F23L3S168' => 'mandatory'],
                ['F18L3S078' => 'elective'],
                ['F18L3S080' => 'elective'],
                ['F18L3S083' => 'elective'],
                ['F18L3S086' => 'elective'],
                ['F18L3S102' => 'elective'],
                ['F18L3S132' => 'elective'],
                ['F23L4W001' => 'elective'],
                ['F18L3S141' => 'elective'],
                ['F18L3S151' => 'elective'],
                ['F23L3S028' => 'elective'],
                ['F18L3S112' => 'elective'],
                ['F18L3S162' => 'elective'],
                ['F23L3S022' => 'elective'],
            ],
        ];

        foreach ($assignments as $programName => $subjects) {
            $program = StudyProgram::where('name_mk', $programName)->first();
            if (!$program) {
                continue;
            }

            foreach ($subjects as $subjectData) {
                foreach ($subjectData as $code => $type) {
                    $subject = Subject::where('code', $code)->first();
                    if ($subject) {
                        $program->subjects()->syncWithoutDetaching([$subject->id => ['type' => $type]]);
                    }
                }
            }
        }

        // Assign subjects to 3-year and 2-year programs from their 4-year counterparts
        // For 3-year programs: use subjects from years 1-3 of the corresponding 4-year program
        // For 2-year programs: use subjects from years 1-2 of the corresponding 4-year program
        $programMappings = [
            // 3-year programs map to 4-year programs with same base name
            '3' => [
                'Софтверско инженерство и информациски системи' => 'Софтверско инженерство и информациски системи',
                'Интернет, мрежи и безбедност' => 'Интернет, мрежи и безбедност',
                'Примена на информациски технологии' => 'Примена на информациски технологии',
                'Компјутерско инженерство' => 'Компјутерско инженерство',
                'Компјутерски науки' => 'Компјутерски науки',
                'Стручни студии за програмирање' => 'Софтверско инженерство и информациски системи',
            ],
            // 2-year programs map to 4-year programs with same base name
            '2' => [
                'Стручни студии за програмирање' => 'Софтверско инженерство и информациски системи',
            ],
        ];

        foreach ($programMappings as $targetDuration => $mappings) {
            foreach ($mappings as $targetName => $sourceName) {
                $targetProgram = StudyProgram::where('name_mk', $targetName)->where('duration_years', $targetDuration)->first();

                // For 2-year programs, copy from 3-year version; for 3-year programs, copy from 4-year version
                $sourceYearDuration = $targetDuration == 2 ? 3 : 4;
                $sourceProgram = StudyProgram::where('name_mk', $sourceName)->where('duration_years', $sourceYearDuration)->first();

                if ($targetProgram && $sourceProgram) {
                    $maxYear = (int)$targetDuration;
                    // For 3-year and 2-year programs, only copy MANDATORY subjects
                    $sourceSubjects = $sourceProgram->subjects()
                        ->wherePivot('type', '!=', null)
                        ->where('year', '<=', $maxYear)
                        ->where('subject_type', 'mandatory')
                        ->get();

                    foreach ($sourceSubjects as $subject) {
                        $type = $subject->pivot->type ?? 'mandatory';
                        $targetProgram->subjects()->syncWithoutDetaching([$subject->id => ['type' => $type]]);
                    }
                }
            }
        }
    }
}
