<?php

namespace Database\Seeders;

use App\Models\Subject;
use Illuminate\Database\Seeder;

class SubjectSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $subjects = [
            [
                'code' => 'F23L1W001',
                'name' => 'Structured Programming',
                'name_mk' => 'Структурирано програмирање',
                'description' => 'Introduction to programming concepts and C language',
                'description_mk' => 'Вовед во концепти на програмирање и C јазик',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W002',
                'name' => 'Calculus I',
                'name_mk' => 'Анализа I',
                'description' => 'Limits, derivatives, and integration',
                'description_mk' => 'Граници, дериватни и интеграли',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W003',
                'name' => 'Discrete Mathematics',
                'name_mk' => 'Дискретна математика',
                'description' => 'Logic, sets, combinatorics, graph theory',
                'description_mk' => 'Логика, множества, комбинаторика, теорија на графови',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S001',
                'name' => 'Calculus II',
                'name_mk' => 'Анализа II',
                'description' => 'Advanced calculus and series',
                'description_mk' => 'Напредна анализа и серии',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S002',
                'name' => 'Linear Algebra',
                'name_mk' => 'Линеарна алгебра',
                'description' => 'Vectors, matrices, eigenvalues',
                'description_mk' => 'Вектори, матрици, карактеристични вредности',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S003',
                'name' => 'Physics I',
                'name_mk' => 'Физика I',
                'description' => 'Mechanics and thermodynamics',
                'description_mk' => 'Механика и термодинамика',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W001',
                'name' => 'Algorithms and Data Structures',
                'name_mk' => 'Алгоритми и податочни структури',
                'description' => 'Fundamental data structures and algorithm design',
                'description_mk' => 'Основни структури и дизајн на алгоритми',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W002',
                'name' => 'Object-Oriented Programming',
                'name_mk' => 'Објектно-ориентирано програмирање',
                'description' => 'Classes, inheritance, polymorphism in C++/Java',
                'description_mk' => 'Класи, наследување, полиморфизам во C++/Java',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W003',
                'name' => 'Digital Logic',
                'name_mk' => 'Дигитална логика',
                'description' => 'Boolean algebra, combinational and sequential circuits',
                'description_mk' => 'Булова алгебра, комбинаторни и секвенцијални кола',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S001',
                'name' => 'Web Programming',
                'name_mk' => 'Веб програмирање',
                'description' => 'HTML, CSS, JavaScript, and web frameworks',
                'description_mk' => 'HTML, CSS, JavaScript, и веб фремворци',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S002',
                'name' => 'Databases I',
                'name_mk' => 'Бази на податоци I',
                'description' => 'Relational model, SQL, database design',
                'description_mk' => 'Релационален модел, SQL, дизајн на БП',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S003',
                'name' => 'Computer Architecture',
                'name_mk' => 'Архитектура на компјутери',
                'description' => 'CPU design, memory hierarchy, assembly language',
                'description_mk' => 'Дизајн на CPU, хиерархија на меморија, асемблер',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W001',
                'name' => 'Operating Systems',
                'name_mk' => 'Оперативни системи',
                'description' => 'Processes, memory management, file systems',
                'description_mk' => 'Процеси, управување со меморија, датотечни системи',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W002',
                'name' => 'Computer Networks',
                'name_mk' => 'Компјутерски мрежи',
                'description' => 'TCP/IP, routing, network protocols',
                'description_mk' => 'TCP/IP, рутирање, мрежни протоколи',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W003',
                'name' => 'Software Engineering',
                'name_mk' => 'Софтверско инженерство',
                'description' => 'SDLC, design patterns, testing, project management',
                'description_mk' => 'SDLC, шаблони на дизајн, тестирање, менаџмент',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S001',
                'name' => 'Cybersecurity',
                'name_mk' => 'Кибербезбедност',
                'description' => 'Encryption, authentication, network security',
                'description_mk' => 'Енкрипција, автентификација, мрежна безбедност',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S002',
                'name' => 'Artificial Intelligence',
                'name_mk' => 'Вештачка интелигенција',
                'description' => 'Search algorithms, machine learning basics',
                'description_mk' => 'Алгоритми за пребарување, основи на машинско учење',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S003',
                'name' => 'Computer Graphics',
                'name_mk' => 'Компјутерска графика',
                'description' => '3D graphics, rendering, shaders',
                'description_mk' => '3D графика, рендерирање, шејдери',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4W001',
                'name' => 'Advanced Databases',
                'name_mk' => 'Напредни бази на податоци',
                'description' => 'Advanced SQL, transactions, optimization',
                'description_mk' => 'Напредна SQL, транзакции, оптимизација',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4W002',
                'name' => 'Machine Learning',
                'name_mk' => 'Машинско учење',
                'description' => 'Classification, regression, neural networks',
                'description_mk' => 'Класификација, регресија, невронски мрежи',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4S001',
                'name' => 'Cloud Computing',
                'name_mk' => 'Облачни компјутери',
                'description' => 'AWS, Azure, GCP, containerization',
                'description_mk' => 'AWS, Azure, GCP, контејнеризација',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'elective',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L4S002',
                'name' => 'Capstone Project',
                'name_mk' => 'Завршен проект',
                'description' => 'Apply learned skills to a real-world project',
                'description_mk' => 'Примена на научени вештини во реален проект',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 0,
                'practice_hours' => 180,
            ],
            [
                'code' => 'F23L1W004',
                'name' => 'Спорт и здравје',
                'name_mk' => 'Спорт и здравје',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W005',
                'name' => 'Бизнис и менаџмент',
                'name_mk' => 'Бизнис и менаџмент',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W007',
                'name' => 'Вовед во компјутерските науки',
                'name_mk' => 'Вовед во компјутерските науки',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W018',
                'name' => 'Професионални вештини',
                'name_mk' => 'Професионални вештини',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1W020',
                'name' => 'Структурно програмирање',
                'name_mk' => 'Структурно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S016',
                'name' => 'Објектно-ориентирано програмирање',
                'name_mk' => 'Објектно-ориентирано програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S015',
                'name' => 'Објектно ориентирана анализа и дизајн',
                'name_mk' => 'Објектно ориентирана анализа и дизајн',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2W014',
                'name' => 'Компјутерски мрежи и безбедност',
                'name_mk' => 'Компјутерски мрежи и безбедност',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S017',
                'name' => 'Оперативни системи',
                'name_mk' => 'Оперативни системи',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S030',
                'name' => 'Вештачка интелигенција',
                'name_mk' => 'Вештачка интелигенција',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S100',
                'name' => 'Деловна пракса',
                'name_mk' => 'Деловна пракса',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W004',
                'name' => 'Бази на податоци',
                'name_mk' => 'Бази на податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W008',
                'name' => 'Вовед во науката за податоци',
                'name_mk' => 'Вовед во науката за податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W009',
                'name' => 'Дизајн и архитектура на софтвер',
                'name_mk' => 'Дизајн и архитектура на софтвер',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W140',
                'name' => 'Напредно програмирање',
                'name_mk' => 'Напредно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S010',
                'name' => 'Дизајн на интеракцијата човек-компјутер',
                'name_mk' => 'Дизајн на интеракцијата човек-компјутер',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S012',
                'name' => 'Интегрирани системи',
                'name_mk' => 'Интегрирани системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S019',
                'name' => 'Софтверски квалитет и тестирање',
                'name_mk' => 'Софтверски квалитет и тестирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S138',
                'name' => 'Напредни бази на податоци',
                'name_mk' => 'Напредни бази на податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3W021',
                'name' => 'Тимски проект',
                'name_mk' => 'Тимски проект',
                'description' => '',
                'description_mk' => '',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S022',
                'name' => 'Управување со ИКТ проекти',
                'name_mk' => 'Управување со ИКТ проекти',
                'description' => '',
                'description_mk' => '',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S028',
                'name' => 'Претприемништво',
                'name_mk' => 'Претприемништво',
                'description' => '',
                'description_mk' => '',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L3S168',
                'name' => 'Дипломска работа',
                'name_mk' => 'Дипломска работа',
                'description' => '',
                'description_mk' => '',
                'year' => 4,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S052',
                'name' => 'Е-учење',
                'name_mk' => 'Е-учење',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S116',
                'name' => 'Компјутерски компоненти',
                'name_mk' => 'Компјутерски компоненти',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S120',
                'name' => 'Креативни вештини за решавање проблеми',
                'name_mk' => 'Креативни вештини за решавање проблеми',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S146',
                'name' => 'Основи на Веб дизајн',
                'name_mk' => 'Основи на Веб дизајн',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S066',
                'name' => 'F23L1S066 Основи на сајбер безбедноста',
                'name_mk' => 'F23L1S066 Основи на сајбер безбедноста',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L1S026',
                'name' => 'F23L2S026 Маркетинг',
                'name_mk' => 'F23L2S026 Маркетинг',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S042',
                'name' => 'Електрични кола',
                'name_mk' => 'Електрични кола',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S051',
                'name' => 'Информатичко размислување во образованието',
                'name_mk' => 'Информатичко размислување во образованието',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S061',
                'name' => 'Безжични и мобилни системи',
                'name_mk' => 'Безжични и мобилни системи',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S082',
                'name' => 'Визуелно програмирање',
                'name_mk' => 'Визуелно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S084',
                'name' => 'Вовед во екоинформатиката',
                'name_mk' => 'Вовед во екоинформатиката',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S090',
                'name' => 'Вовед во случајни процеси',
                'name_mk' => 'Вовед во случајни процеси',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F23L2S095',
                'name' => 'Дигитално процесирање на слика',
                'name_mk' => 'Дигитално процесирање на слика',
                'description' => '',
                'description_mk' => '',
                'year' => 5,
                'semester_type' => 'summer',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S151',
                'name' => 'Пресметковна биологија',
                'name_mk' => 'Пресметковна биологија',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W038',
                'name' => 'Програмски парадигми',
                'name_mk' => 'Програмски парадигми',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W123',
                'name' => 'Machine Vision',
                'name_mk' => 'Machine Vision',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S141',
                'name' => 'Неструктурирани бази на податоци',
                'name_mk' => 'Неструктурирани бази на податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S114',
                'name' => 'Computer graphics',
                'name_mk' => 'Computer graphics',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S155',
                'name' => 'Сервисно ориентирани архитектури',
                'name_mk' => 'Сервисно ориентирани архитектури',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S019',
                'name' => 'Софтверски квалитет и тестирање',
                'name_mk' => 'Софтверски квалитет и тестирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S030',
                'name' => 'Вештачка интелигенција',
                'name_mk' => 'Вештачка интелигенција',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S093',
                'name' => 'Digital Forensics',
                'name_mk' => 'Digital Forensics',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S057',
                'name' => 'Работа со надарен и ученици',
                'name_mk' => 'Работа со надарен и ученици',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S091',
                'name' => 'Geographic Information Systems',
                'name_mk' => 'Geographic Information Systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W005',
                'name' => 'Business and Management',
                'name_mk' => 'Business and Management',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S107',
                'name' => 'Intelligent systems',
                'name_mk' => 'Intelligent systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S125',
                'name' => 'Мерење и анализа на интернет сообраќај',
                'name_mk' => 'Мерење и анализа на интернет сообраќај',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W072',
                'name' => 'Autonomous robotics',
                'name_mk' => 'Autonomous robotics',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W136',
                'name' => 'Advanced Web Design',
                'name_mk' => 'Advanced Web Design',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S082',
                'name' => 'Визуелно програмирање',
                'name_mk' => 'Визуелно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W096',
                'name' => 'Дигитизација',
                'name_mk' => 'Дигитизација',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W104',
                'name' => 'Еngineering mathematics',
                'name_mk' => 'Еngineering mathematics',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W152',
                'name' => 'Video games programming',
                'name_mk' => 'Video games programming',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W103',
                'name' => 'Имплементација на системи со слободен и отворен код',
                'name_mk' => 'Имплементација на системи со слободен и отворен код',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W004',
                'name' => 'Бази на податоци',
                'name_mk' => 'Бази на податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S159',
                'name' => 'Software defined security',
                'name_mk' => 'Software defined security',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W031',
                'name' => 'Дискретни структури 1',
                'name_mk' => 'Дискретни структури 1',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W148',
                'name' => 'Основи на роботиката',
                'name_mk' => 'Основи на роботиката',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W154',
                'name' => 'Рударење на масивни податоци',
                'name_mk' => 'Рударење на масивни податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S139',
                'name' => 'Напредни теми од криптогра фија',
                'name_mk' => 'Напредни теми од криптогра фија',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S028',
                'name' => 'Entrepreneurship',
                'name_mk' => 'Entrepreneurship',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S025',
                'name' => 'Electronic and Mobile Commerce',
                'name_mk' => 'Electronic and Mobile Commerce',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W144',
                'name' => 'Operations research',
                'name_mk' => 'Operations research',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W074',
                'name' => 'Database administration',
                'name_mk' => 'Database administration',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W161',
                'name' => 'Социјални мрежи и медиуми',
                'name_mk' => 'Социјални мрежи и медиуми',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S023',
                'name' => 'Бизнис статистика',
                'name_mk' => 'Бизнис статистика',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W008',
                'name' => 'Вовед во науката за податоци',
                'name_mk' => 'Вовед во науката за податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W006',
                'name' => 'Probability and statistics',
                'name_mk' => 'Probability and statistics',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W079',
                'name' => 'Web Based Systems',
                'name_mk' => 'Web Based Systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W160',
                'name' => 'Software defined networks',
                'name_mk' => 'Software defined networks',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S146',
                'name' => 'Основи на веб дизајн',
                'name_mk' => 'Основи на веб дизајн',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W037',
                'name' => 'Паралелно и дистрибуирано процесирање',
                'name_mk' => 'Паралелно и дистрибуирано процесирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S069',
                'name' => 'Македонски јазик',
                'name_mk' => 'Македонски јазик',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S017',
                'name' => 'Operating systems',
                'name_mk' => 'Operating systems',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S062',
                'name' => 'Virtualization',
                'name_mk' => 'Virtualization',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S102',
                'name' => 'ИКТ за развој',
                'name_mk' => 'ИКТ за развој',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W044',
                'name' => 'Компјутерска електроника',
                'name_mk' => 'Компјутерска електроника',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W064',
                'name' => 'Дистрибуирани системи',
                'name_mk' => 'Дистрибуирани системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S087',
                'name' => 'Introduction to network science',
                'name_mk' => 'Introduction to network science',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W060',
                'name' => 'Администрација на системи',
                'name_mk' => 'Администрација на системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W129',
                'name' => 'Mobile platforms and programming',
                'name_mk' => 'Mobile platforms and programming',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S121',
                'name' => 'Blockchain and cryptocurrencies',
                'name_mk' => 'Blockchain and cryptocurrencies',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W085',
                'name' => 'Вовед во биоинформатиката',
                'name_mk' => 'Вовед во биоинформатиката',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W109',
                'name' => 'Интернет програмирање на клиентска страна',
                'name_mk' => 'Интернет програмирање на клиентска страна',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S113',
                'name' => 'Computer Animation',
                'name_mk' => 'Computer Animation',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W020',
                'name' => 'Структурно програмирање',
                'name_mk' => 'Структурно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W142',
                'name' => 'Natural language processing',
                'name_mk' => 'Natural language processing',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S118',
                'name' => 'Континуирана интеграција и испорака',
                'name_mk' => 'Континуирана интеграција и испорака',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W018',
                'name' => 'Професионални вештини',
                'name_mk' => 'Професионални вештини',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S013',
                'name' => 'Calculus',
                'name_mk' => 'Calculus',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18W3S085',
                'name' => 'Introduction to Bioinformatics',
                'name_mk' => 'Introduction to Bioinformatics',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W126',
                'name' => 'Методологија на истражувањето во ИКТ',
                'name_mk' => 'Методологија на истражувањето во ИКТ',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W089',
                'name' => 'Вовед во препознавање на облици',
                'name_mk' => 'Вовед во препознавање на облици',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S036',
                'name' => 'Machine learning',
                'name_mk' => 'Machine learning',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W165',
                'name' => 'Управување со техничката поддршка',
                'name_mk' => 'Управување со техничката поддршка',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S080',
                'name' => 'Веб пребарувачки системи',
                'name_mk' => 'Веб пребарувачки системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W068',
                'name' => 'Cloud computing',
                'name_mk' => 'Cloud computing',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W046',
                'name' => 'Компјутерски мрежи',
                'name_mk' => 'Компјутерски мрежи',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S002',
                'name' => 'Анализа на софтверските барања',
                'name_mk' => 'Анализа на софтверските барања',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S045',
                'name' => 'Компјутерски архитектури',
                'name_mk' => 'Компјутерски архитектури',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W007',
                'name' => 'Вовед во компјутерските науки',
                'name_mk' => 'Вовед во компјутерските науки',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S130',
                'name' => 'Business process modeling and management',
                'name_mk' => 'Business process modeling and management',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S066',
                'name' => 'Основи на сајбер безбедноста',
                'name_mk' => 'Основи на сајбер безбедноста',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S127',
                'name' => 'Mobile Applications',
                'name_mk' => 'Mobile Applications',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W024',
                'name' => 'Web Programming',
                'name_mk' => 'Web Programming',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S100',
                'name' => 'Економија за ИКТ инженери',
                'name_mk' => 'Економија за ИКТ инженери',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S051',
                'name' => 'ИКТ во образованието',
                'name_mk' => 'ИКТ во образованието',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S158',
                'name' => 'Современи компјутерски архитектури',
                'name_mk' => 'Современи компјутерски архитектури',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W048',
                'name' => 'Software for embedded systems',
                'name_mk' => 'Software for embedded systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S162',
                'name' => 'Споделување и пресметување во толпа',
                'name_mk' => 'Споделување и пресметување во толпа',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W098',
                'name' => 'Дистрибуирано складирање на податоци',
                'name_mk' => 'Дистрибуирано складирање на податоци',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S164',
                'name' => 'Information theory and digital communications',
                'name_mk' => 'Information theory and digital communications',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W128',
                'name' => 'Мобилни информациски системи',
                'name_mk' => 'Мобилни информациски системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W081',
                'name' => 'Визуелизација',
                'name_mk' => 'Визуелизација',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S015',
                'name' => 'Објектно ориентирана анализа и дизајн',
                'name_mk' => 'Објектно ориентирана анализа и дизајн',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S003',
                'name' => 'Архитектура и организација на компјутери',
                'name_mk' => 'Архитектура и организација на компјутери',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W137',
                'name' => 'Напредна интеракција човек компјутер',
                'name_mk' => 'Напредна интеракција човек компјутер',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W092',
                'name' => 'Digital Post-production',
                'name_mk' => 'Digital Post-production',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S012',
                'name' => 'Интегрирани системи',
                'name_mk' => 'Интегрирани системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S143',
                'name' => 'Одржливи и енергетски ефикасни компјутерски',
                'name_mk' => 'Одржливи и енергетски ефикасни компјутерски',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W075',
                'name' => 'Information Systems Analysis and Design',
                'name_mk' => 'Information Systems Analysis and Design',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W105',
                'name' => 'Innovation in ICT',
                'name_mk' => 'Innovation in ICT',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S086',
                'name' => 'Вовед во когнитивни науки',
                'name_mk' => 'Вовед во когнитивни науки',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S120',
                'name' => 'Puzzle based learning',
                'name_mk' => 'Puzzle based learning',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'CSEW522',
                'name' => 'Напреден веб дизајн',
                'name_mk' => 'Напреден веб дизајн',
                'description' => '',
                'description_mk' => '',
                'year' => 4,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S097',
                'name' => 'Algorithm design',
                'name_mk' => 'Algorithm design',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W043',
                'name' => 'Информациска безбедност',
                'name_mk' => 'Информациска безбедност',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S054',
                'name' => 'Методика на информатиката',
                'name_mk' => 'Методика на информатиката',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S073',
                'name' => 'Agent-based systems',
                'name_mk' => 'Agent-based systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S138',
                'name' => 'Advanced Databases',
                'name_mk' => 'Advanced Databases',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W108',
                'name' => 'IoT',
                'name_mk' => 'IoT',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W067',
                'name' => 'Основи на теоријата на информации',
                'name_mk' => 'Основи на теоријата на информации',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S163',
                'name' => 'Статистичко моделирање',
                'name_mk' => 'Статистичко моделирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S040',
                'name' => 'Embedded microprocessor systems',
                'name_mk' => 'Embedded microprocessor systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W027',
                'name' => 'Менаџмент информациски системи',
                'name_mk' => 'Менаџмент информациски системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W041',
                'name' => 'Дизајн на дигитални кола',
                'name_mk' => 'Дизајн на дигитални кола',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S150',
                'name' => 'Data mining',
                'name_mk' => 'Data mining',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W001',
                'name' => 'Algorithms and Data Structures',
                'name_mk' => 'Algorithms and Data Structures',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S090',
                'name' => 'Вовед во случајни процеси',
                'name_mk' => 'Вовед во случајни процеси',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W033',
                'name' => 'Калкулус 1',
                'name_mk' => 'Калкулус 1',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S039',
                'name' => 'Formal languages and automata',
                'name_mk' => 'Formal languages and automata',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S042',
                'name' => 'Electric Circuits',
                'name_mk' => 'Electric Circuits',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S111',
                'name' => 'Инфраструктурно програмирање',
                'name_mk' => 'Инфраструктурно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W011',
                'name' => 'Discrete Mathematics',
                'name_mk' => 'Discrete Mathematics',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S016',
                'name' => 'Object oriented programming',
                'name_mk' => 'Object oriented programming',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W088',
                'name' => 'Introduction to Smart Cities',
                'name_mk' => 'Introduction to Smart Cities',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W009',
                'name' => 'Software Design and Architecture',
                'name_mk' => 'Software Design and Architecture',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S110',
                'name' => 'Интернет технологии',
                'name_mk' => 'Интернет технологии',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S099',
                'name' => 'E-government',
                'name_mk' => 'E-government',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S032',
                'name' => 'Дискретни структури 2',
                'name_mk' => 'Дискретни структури 2',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S149',
                'name' => 'Parallel programming',
                'name_mk' => 'Parallel programming',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W156',
                'name' => 'Decision support systems',
                'name_mk' => 'Decision support systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S112',
                'name' => 'Програмски јазици и компајлери',
                'name_mk' => 'Програмски јазици и компајлери',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S083',
                'name' => 'Виртуелна реалност',
                'name_mk' => 'Виртуелна реалност',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W053',
                'name' => 'Computer ethics',
                'name_mk' => 'Computer ethics',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W014',
                'name' => 'Computer Networks and Security',
                'name_mk' => 'Computer Networks and Security',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S084',
                'name' => 'Вовед во екоинформатиката',
                'name_mk' => 'Вовед во екоинформатиката',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S157',
                'name' => 'Data Warehouses and OLAP',
                'name_mk' => 'Data Warehouses and OLAP',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S010',
                'name' => 'Human-computer interaction design',
                'name_mk' => 'Human-computer interaction design',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S077',
                'name' => 'Безжични мултимедиски системи',
                'name_mk' => 'Безжични мултимедиски системи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S132',
                'name' => 'Модерни трендови во роботика',
                'name_mk' => 'Модерни трендови во роботика',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S135',
                'name' => 'Multimedia systems',
                'name_mk' => 'Multimedia systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W167',
                'name' => 'User interfaces design patterns',
                'name_mk' => 'User interfaces design patterns',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W133',
                'name' => 'Мрежна и мобилна форензика',
                'name_mk' => 'Мрежна и мобилна форензика',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S124',
                'name' => 'Медиуми и комуникации',
                'name_mk' => 'Медиуми и комуникации',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S119',
                'name' => 'Концепти на информатичко општество',
                'name_mk' => 'Концепти на информатичко општество',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S059',
                'name' => 'Администрација на мрежи',
                'name_mk' => 'Администрација на мрежи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S153',
                'name' => 'Процесна роботика',
                'name_mk' => 'Процесна роботика',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W021',
                'name' => 'Тимски проект',
                'name_mk' => 'Тимски проект',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W065',
                'name' => 'Мрежна безбедност',
                'name_mk' => 'Мрежна безбедност',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W134',
                'name' => 'Multimedia Networks',
                'name_mk' => 'Multimedia Networks',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S106',
                'name' => 'Intelligent Information Systems',
                'name_mk' => 'Intelligent Information Systems',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S034',
                'name' => 'Калкулус 2',
                'name_mk' => 'Калкулус 2',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W145',
                'name' => 'Оптички мрежи',
                'name_mk' => 'Оптички мрежи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S061',
                'name' => 'Wireless mobile systems',
                'name_mk' => 'Wireless mobile systems',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W049',
                'name' => 'Физика',
                'name_mk' => 'Физика',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S022',
                'name' => 'Управување со ИКТ проекти',
                'name_mk' => 'Управување со ИКТ проекти',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S084',
                'name' => 'Introduction to Ecoinformatics',
                'name_mk' => 'Introduction to Ecoinformatics',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S071',
                'name' => 'Психологија на училишна возраст',
                'name_mk' => 'Психологија на училишна возраст',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S101',
                'name' => 'Етичко хакирање',
                'name_mk' => 'Етичко хакирање',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S026',
                'name' => 'Marketing',
                'name_mk' => 'Marketing',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W115',
                'name' => 'Компјутерски звук, говор и музика',
                'name_mk' => 'Компјутерски звук, говор и музика',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W035',
                'name' => 'Linear algebra and applications',
                'name_mk' => 'Linear algebra and applications',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S122',
                'name' => 'Криптографија',
                'name_mk' => 'Криптографија',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S166',
                'name' => 'Учење на далечина',
                'name_mk' => 'Учење на далечина',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S078',
                'name' => 'Биолошки инспирирано пресметување',
                'name_mk' => 'Биолошки инспирирано пресметување',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1W070',
                'name' => 'Педагогија',
                'name_mk' => 'Педагогија',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W140',
                'name' => 'Напредно програмирање',
                'name_mk' => 'Напредно програмирање',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S116',
                'name' => 'Computer Components',
                'name_mk' => 'Computer Components',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W117',
                'name' => 'Компјутерски поддржано производство',
                'name_mk' => 'Компјутерски поддржано производство',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S094',
                'name' => 'Дигитални библиотеки',
                'name_mk' => 'Дигитални библиотеки',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S029',
                'name' => 'Софтверско инженерство',
                'name_mk' => 'Софтверско инженерство',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2W147',
                'name' => 'Основи на комуникациски системи',
                'name_mk' => 'Основи на комуникациски системи',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W131',
                'name' => 'Моделирање и симулација',
                'name_mk' => 'Моделирање и симулација',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W076',
                'name' => 'Вовед во анализа на временските серии',
                'name_mk' => 'Вовед во анализа на временските серии',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L1S052',
                'name' => 'ИТ системи за учење',
                'name_mk' => 'ИТ системи за учење',
                'description' => '',
                'description_mk' => '',
                'year' => 1,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S047',
                'name' => 'Signal processing',
                'name_mk' => 'Signal processing',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S056',
                'name' => 'Персонализирано учење',
                'name_mk' => 'Персонализирано учење',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W055',
                'name' => 'Мултимедија лни технологии',
                'name_mk' => 'Мултимедија лни технологии',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L2S095',
                'name' => 'Дигитално процесирање на слика',
                'name_mk' => 'Дигитално процесирање на слика',
                'description' => '',
                'description_mk' => '',
                'year' => 2,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3W050',
                'name' => 'Дизајн на образовен софтвер',
                'name_mk' => 'Дизајн на образовен софтвер',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
            [
                'code' => 'F18L3S063',
                'name' => 'Дизајн на компјутерски мрежи',
                'name_mk' => 'Дизајн на компјутерски мрежи',
                'description' => '',
                'description_mk' => '',
                'year' => 3,
                'semester_type' => 'winter',
                'subject_type' => 'mandatory',
                'credits' => 6,
                'lecture_hours' => 30,
                'practice_hours' => 60,
            ],
        ];

        foreach ($subjects as $subject) {
            Subject::create($subject);
        }
    }
}
