import React, {useState} from "react";
import {Col, Container, Row, Carousel} from "react-bootstrap";
import MenuItem from "./MenuItem";

const Menu = (props) => {
    const menu = props.menu

    console.log(menu)
    const partitionBy3 = (arr) => {
        const rowPartitions = Array.from({length: Math.ceil(arr.length / 5)}, (v, i) =>
            arr.slice(i * 5, i * 5 + 5)
        );
        return Array.from({length: Math.ceil(rowPartitions.length / 2)}, (v, i) =>
            rowPartitions.slice(i * 2, i * 2 + 2)
        );
    }

    const [ind, setIndex] = useState(0);

    const handleSelect = (selectedIndex) => {
        setIndex(selectedIndex);
    };


    return (<>
        <Carousel activeIndex={ind} onSelect={handleSelect} indicators={false}>
            {partitionBy3(menu).map((slides, index) => {
                return (
                    <Carousel.Item key={index}>
                        {slides.map((row) => {
                            return (
                                <Row>
                                    {row.map((menuItem) => {
                                        return (
                                            <Col>
                                                <MenuItem data={menuItem}/>
                                            </Col>
                                        )
                                    })}
                                </Row>
                            )
                        })}
                    </Carousel.Item>)
            })}
        </Carousel>
    </>)
}

export default Menu;