import React from "react";
import Form from "react-bootstrap/Form";
import FaHotel from "react-icons/fa";
import {Button} from "react-bootstrap";
import useCreate from "../Hooks/useCreate";
import TableRow from "./TableRow";

const TablesTable = (props) => {

    console.log(props)


    return (
        <>
            <table className="m-auto table table-hover table-responsive">
                <thead>
                <tr>
                    <th scope="col">Тип на маса</th>
                    <th scope="col">Колку единици?</th>
                    <th scope="col"></th>
                </tr>
                </thead>
                <tbody>
                {Array.from(new Set(props.data.map(x => x.restaurantTable))).map((table) => {
                    return (
                        <>
                            <TableRow
                                params={props.params}
                                availableId={props.data.filter(x => x.restaurantTable.tableId === table.tableId).
                                map(x => x.restaurantAvailibleId)[0]}
                                data={props.data} table={table} from={props.from} to={props.to}/>
                        </>
                    );
                })}
                </tbody>
            </table>
        </>
    );
};

export default TablesTable;
