DROP DATABASE IF EXISTS ddl_script_travel_sage;
CREATE DATABASE ddl_script_travel_sage;
USE ddl_script_travel_sage;

DROP TABLE IF EXISTS DESTINACII CASCADE;
DROP TABLE IF EXISTS KORISNICI CASCADE;
DROP TABLE IF EXISTS STANDARD CASCADE;
DROP TABLE IF EXISTS PREMIUM  CASCADE;
DROP TABLE IF EXISTS RECENZII CASCADE;
DROP TABLE IF EXISTS METEROLOSHKASOSTOJBA CASCADE;
DROP TABLE IF EXISTS PAKETI CASCADE;
DROP TABLE IF EXISTS AKTIVNOSTI CASCADE;
DROP TABLE IF EXISTS REZERVACII CASCADE;
DROP TABLE IF EXISTS PREFERENCI CASCADE;
DROP TABLE IF EXISTS NASTANI CASCADE;
DROP TABLE IF EXISTS TAGOVI CASCADE;

CREATE TABLE TAGOVI (
    idTag INT AUTO_INCREMENT PRIMARY KEY,
    tagOznaka VARCHAR(255) NOT NULL
);

CREATE TABLE DESTINACII (
    idDest INT AUTO_INCREMENT PRIMARY KEY,
    imeLokacija VARCHAR(255) NOT NULL,
    opisLokacija VARCHAR(255),
    tipoviMesta VARCHAR(255) NOT NULL,
    preporachanaSezona VARCHAR(255) NOT NULL,
    prosechnaTemp DECIMAL(5, 2),
    -- geoLokacija GEOGRAPHY(Point, 4326)  KOORDINATI
    lat DECIMAL(9, 6),   
	lon DECIMAL(9, 6),
    drzhava VARCHAR(255),
    popularnost INT,
    ime VARCHAR(255) NOT NULL,
    opis VARCHAR(255) NOT NULL, 
    idTag INT,
	CONSTRAINT fk_tag_dest FOREIGN KEY (idTag) REFERENCES TAGOVI(idTag)
);

CREATE TABLE METEROLOSHKASOSTOJBA (
    idMeteo INT AUTO_INCREMENT PRIMARY KEY,
    momentTemp DECIMAL(5, 2),
    sostojbaVreme VARCHAR(255) NOT NULL,
    predupreduvanja VARCHAR(255) NOT NULL,
    vlazhnost DECIMAL(5, 2),
    veter DECIMAL(5, 2),
    mesec INT,
    idDest INT,
    CONSTRAINT fk_dest_meteo FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE AKTIVNOSTI (
    idAktivnost INT AUTO_INCREMENT PRIMARY KEY,
    imeAktivnost VARCHAR(255) NOT NULL,
    informacii VARCHAR(255),
    kategorija VARCHAR(255) NOT NULL,
    iznos INT,
    idDest INT,
    CONSTRAINT fk_dest_aktivnost FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE KORISNICI (
    idKorisnik INT AUTO_INCREMENT PRIMARY KEY,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    idDest INT,
    CONSTRAINT fk_dest_korisnik FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

CREATE TABLE STANDARD (
    idKorisnik INT,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    CONSTRAINT fk_korisnik_standard FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE PREMIUM (
    idKorisnik INT,
    ime VARCHAR(255) NOT NULL,
    prezime VARCHAR(255) NOT NULL,
    ePoshta VARCHAR(255) NOT NULL UNIQUE,
    telBr VARCHAR(255) NOT NULL,
    datumRagjanje DATE,
    datumKreiranje DATE,
    popust DECIMAL(5, 2),
    CONSTRAINT fk_korisnik_premium FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE REZERVACII (
    idRezervacija INT AUTO_INCREMENT PRIMARY KEY,
    vremenskaTochka DATE NOT NULL,
    vkupnaCena INT NOT NULL,
    idAktivnost INT,
    idKorisnik INT,
    idMeteo INT,
    CONSTRAINT fk_aktivnost_rezervacija FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_korisnik_rezervacija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_meteo_rezervacija FOREIGN KEY (idMeteo) REFERENCES METEROLOSHKASOSTOJBA(idMeteo)
);

CREATE TABLE RECENZII (
    idRecenzija INT AUTO_INCREMENT PRIMARY KEY,
    korisnichkoIme VARCHAR(255) NOT NULL,
    kvalitet INT NOT NULL,
    zabeleshka VARCHAR(255),
    datumRecenzija DATE,
    brGlasovi INT,
    idDest INT,
    idKorisnik INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_recenzija FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_korisnik_recenzija FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik),
    CONSTRAINT fk_rezervacija_recenzija FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE PAKETI (
    idPaket INT AUTO_INCREMENT PRIMARY KEY,
    imePaket VARCHAR(255) NOT NULL,
    cena INT NOT NULL,
    pochetok DATETIME NOT NULL,
    kraj DATETIME NOT NULL,
    idDest INT,
    idAktivnost INT,
    idRezervacija INT,
    CONSTRAINT fk_dest_paket FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest),
    CONSTRAINT fk_aktivnost_paket FOREIGN KEY (idAktivnost) REFERENCES AKTIVNOSTI(idAktivnost),
    CONSTRAINT fk_rezervacija_paket FOREIGN KEY (idRezervacija) REFERENCES REZERVACII(idRezervacija)
);

CREATE TABLE PREFERENCI (
    idPreferenca INT AUTO_INCREMENT PRIMARY KEY,
    tipPreferenca VARCHAR(255) NOT NULL,
    prioritet INT,
    idKorisnik INT,
    CONSTRAINT fk_korisnik_preferenca FOREIGN KEY (idKorisnik) REFERENCES KORISNICI(idKorisnik)
);

CREATE TABLE NASTANI (
    idNastan INT AUTO_INCREMENT PRIMARY KEY,
    naziv VARCHAR(255) NOT NULL,
    vidovi VARCHAR(255) NOT NULL,
    pochetenDatum DATE,
    kraenDatum DATE,
    detali VARCHAR(255),
    idDest INT,
    CONSTRAINT fk_dest_nastan FOREIGN KEY (idDest) REFERENCES DESTINACII(idDest)
);

ALTER TABLE DESTINACII ADD FOREIGN KEY (idTag) REFERENCES TAGOVI(idTag);

