SET search_path TO trekr;

-- ============================
-- USERS
-- ============================
INSERT INTO USERS (user_id, email, username, password) VALUES
(1, 'dimitar@example.com', 'dimitar_arsov', '$2a$10$examplehash1'),
(2, 'filip@example.com', 'filip_gavrilovski', '$2a$10$examplehash2'),
(3, 'marko@example.com', 'marko_markovski', '$2a$10$examplehash3'),
(4, 'andrej.shumanovski@gmail.com', 'andrej_shumanovski', '1234'),
(5, 'angelovski.mario222@gmail.com', 'angelovski_mario', '1234'),
(6, 'ana@example.com', 'ana_ilievska', '$2a$10$examplehash6'),
(7, 'petar@example.com', 'petar_stojanov', '$2a$10$examplehash7'),
(8, 'elena@example.com', 'elena_ristova', '$2a$10$examplehash8'),
(9, 'stefan@example.com', 'stefan_nikolov', '$2a$10$examplehash9'),
(10, 'ivana@example.com', 'ivana_karapandzova', '$2a$10$examplehash10');

-- ============================
-- FINANCE
-- ============================
INSERT INTO FINANCE_USERS (user_id, spending_budget, saving_budget, investing_budget, donation_budget, credit) VALUES
(1, 500, 200, 300, 50, 1000),
(2, 600, 250, 200, 30, 500),
(3, 400, 150, 250, 20, 0),
(4, 1000, 500, 500, 100, 2000),
(5, 700, 300, 200, 40, 800),
(6, 450, 150, 150, 20, 200),
(7, 900, 350, 250, 60, 1200),
(8, 550, 200, 300, 25, 0),
(9, 800, 300, 400, 50, 1500),
(10, 650, 250, 200, 30, 400);

INSERT INTO INCOMES (income_id, user_id, date, amount) VALUES
(1, 1, '2026-01-01', 2000),
(2, 2, '2026-01-03', 1800),
(3, 3, '2026-01-05', 2200),
(4, 4, '2026-01-07', 5000),
(5, 5, '2026-01-08', 3200),
(6, 6, '2026-01-10', 1600),
(7, 7, '2026-01-12', 4100),
(8, 8, '2026-01-14', 2300),
(9, 9, '2026-01-16', 3700),
(10, 10, '2026-01-18', 1900);

-- ============================
-- TRAINING
-- ============================
INSERT INTO TRAINING_USERS (user_id, gender, age, weight) VALUES
(1, 'Male', 21, 73),
(2, 'Male', 23, 80),
(3, 'Male', 22, 78),
(4, 'Female', 25, 65),
(5, 'Male', 24, 86),
(6, 'Female', 22, 58),
(7, 'Male', 28, 92),
(8, 'Female', 26, 70),
(9, 'Male', 30, 83),
(10, 'Female', 21, 62);

-- ============================
-- WEIGHT & DAILY INTAKES
-- ============================
INSERT INTO WEIGHT_USERS (user_id, weight, height, goal_weight, goal_calories) VALUES
(1, 73, 181, 70, 2500),
(2, 80, 185, 75, 2600),
(3, 78, 180, 74, 2400),
(4, 65, 170, 60, 2000),
(5, 86, 188, 80, 2800),
(6, 58, 165, 55, 1900),
(7, 92, 190, 85, 3000),
(8, 70, 172, 66, 2100),
(9, 83, 179, 78, 2500),
(10, 62, 168, 58, 2000);

INSERT INTO TRAINING_SESSIONS (training_id, training_user_id, weight_user_id, duration, calories, date, type) VALUES
(1, 1, 1, 60, 500, '2026-02-01', 'Running'),
(2, 2, 2, 45, 400, '2026-02-01', 'Cycling'),
(3, 3, 3, 30, 300, '2026-02-01', 'Swimming'),
(4, 4, 4, 50, 420, '2026-02-02', 'HIIT'),
(5, 5, 5, 40, 350, '2026-02-02', 'Strength'),
(6, 6, 6, 35, 280, '2026-02-02', 'Yoga'),
(7, 7, 7, 55, 520, '2026-02-03', 'Running'),
(8, 8, 8, 45, 390, '2026-02-03', 'Cycling'),
(9, 9, 9, 30, 260, '2026-02-03', 'Rowing'),
(10, 10, 10, 60, 480, '2026-02-04', 'Swimming');

INSERT INTO DAILY_INTAKES (daily_intake_id, user_id, calories, date) VALUES
(1, 1, 2400, '2026-02-01'),
(2, 2, 2500, '2026-02-01'),
(3, 3, 2300, '2026-02-01'),
(4, 4, 2100, '2026-02-02'),
(5, 5, 2750, '2026-02-02'),
(6, 6, 1850, '2026-02-02'),
(7, 7, 2950, '2026-02-03'),
(8, 8, 2050, '2026-02-03'),
(9, 9, 2450, '2026-02-03'),
(10, 10, 1950, '2026-02-04');

-- ============================
-- DISCIPLINE & CUSTOM TRACKING
-- ============================
INSERT INTO DISCIPLINE_USERS (user_id, num_tasks, tasks) VALUES
(1, 2, '["Morning Run","Read Book"]'),
(2, 1, '["Meditation"]'),
(3, 3, '["Plan Day","No Sugar","Stretch"]'),
(4, 2, '["Drink Water","Walk 8k Steps"]'),
(5, 2, '["Journal","Gym"]'),
(6, 1, '["Study 1h"]');

INSERT INTO CUSTOM_TRACKING_CATEGORIES (custom_tracking_id, user_id, name, num_tasks, tasks) VALUES
(1, 1, 'Project Trekr', 2, '["Code Review","Push Updates"]'),
(2, 2, 'Language Learning', 2, '["Duolingo","Watch Lesson"]'),
(3, 3, 'Side Hustle', 3, '["Client Outreach","Build Feature","Invoice"]'),
(4, 5, 'Fitness Plan', 2, '["Protein Target","Sleep 8h"]'),
(5, 6, 'Exam Prep', 2, '["Practice Problems","Review Notes"]');

-- ============================
-- TASKS & COMPLETION
-- ============================
INSERT INTO TASKS (task_id, name, discipline_user_id, custom_tracking_id) VALUES
(1, 'Morning Run', 1, NULL),
(2, 'Read Book', 1, NULL),
(3, 'Meditation', 2, NULL),
(4, 'Code Review', NULL, 1),
(5, 'Push Updates', NULL, 1),
(6, 'Plan Day', 3, NULL),
(7, 'No Sugar', 3, NULL),
(8, 'Stretch', 3, NULL),
(9, 'Drink Water', 4, NULL),
(10, 'Walk 8k Steps', 4, NULL),
(11, 'Journal', 5, NULL),
(12, 'Gym', 5, NULL),
(13, 'Duolingo', NULL, 2),
(14, 'Watch Lesson', NULL, 2),
(15, 'Practice Problems', NULL, 5);

INSERT INTO DAILY_COMPLETION (daily_completion_id, user_id, date, procent) VALUES
(1, 1, '2026-02-01', 100),
(2, 2, '2026-02-01', 50),
(3, 3, '2026-02-01', 67),
(4, 4, '2026-02-01', 50),
(5, 5, '2026-02-02', 100),
(6, 6, '2026-02-02', 0),
(7, 7, '2026-02-03', 80),
(8, 8, '2026-02-03', 60),
(9, 9, '2026-02-03', 40),
(10, 10, '2026-02-04', 90);

INSERT INTO TASK_DAILY_COMPLETION (task_id, daily_completion_id) VALUES
(1, 1),
(2, 1),
(3, 2),
(6, 3),
(7, 3),
(9, 4),
(11, 5),
(12, 5),
(13, 8),
(14, 8),
(15, 10);

-- ============================
-- INVESTING
-- ============================
INSERT INTO INVESTOR_USERS (user_id) VALUES
(1), (2), (3), (4), (5), (6);

INSERT INTO ASSETS (asset_id, user_id, ticker_symbol, buy_price, buy_date, quantity) VALUES
(1, 1, 'AAPL', 150, '2026-01-01',1.5),
(2, 1, 'TSLA', 700, '2026-01-10',2),
(3, 2, 'GOOGL', 2800, '2026-01-15',1),
(4, 3, 'MSFT', 320, '2026-01-20',1),
(5, 4, 'AMZN', 155, '2026-01-22',1),
(6, 5, 'NVDA', 610, '2026-01-25',1),
(7, 6, 'SPY', 480, '2026-01-28',1),
(8, 1, 'ETH', 2400, '2026-01-30',1);