
INSERT INTO "User" (full_name, email, phone, created_at) VALUES
('Emma Johnson', 'emma.johnson@email.com', '555-0101', '2024-01-15 10:30:00'),
('Sophia Martinez', 'sophia.martinez@email.com', '555-0102', '2024-01-20 14:15:00'),
('Olivia Brown', 'olivia.brown@email.com', '555-0103', '2024-02-01 09:00:00'),
('Isabella Davis', 'isabella.davis@email.com', '555-0104', '2024-02-10 11:45:00'),
('Mia Wilson', 'mia.wilson@email.com', '555-0105', '2024-02-15 16:20:00');


INSERT INTO Role (name) VALUES
('Customer'),
('Stylist'),
('Manager'),
('Receptionist');


INSERT INTO Category (name) VALUES
('Hair Services'),
('Nail Services'),
('Spa & Massage'),
('Facial Treatments');


INSERT INTO Status (name) VALUES
('Scheduled'),
('Completed'),
('Cancelled'),
('No-Show');


INSERT INTO Service (name, price, duration_minutes, category_id) VALUES
('Women Haircut & Style', 65.00, 60, 1),
('Hair Coloring', 120.00, 120, 1),
('Blowout', 45.00, 45, 1),
('Deep Conditioning Treatment', 55.00, 30, 1),
('Manicure', 35.00, 45, 2),
('Pedicure', 50.00, 60, 2),
('Gel Nails', 65.00, 75, 2),


('Swedish Massage', 90.00, 60, 3),
('Hot Stone Massage', 115.00, 75, 3),
('Aromatherapy Massage', 100.00, 60, 3),


('Classic Facial', 80.00, 60, 4),
('Anti-Aging Facial', 110.00, 75, 4),
('Hydrating Facial', 85.00, 60, 4);


INSERT INTO Package (name, max_usage) VALUES
('Pamper Package', 5),
('Bridal Beauty Package', 3),
('Monthly Wellness Package', 10);



INSERT INTO PackageService (package_id, service_id, discounted_price) VALUES

(1, 1, 55.00),  
(1, 5, 28.00),  
(1, 6, 42.00),  
(1, 11, 70.00), 

(2, 2, 100.00), 
(2, 3, 38.00),  
(2, 7, 55.00),  
(2, 12, 95.00), 

(3, 8, 75.00),  
(3, 10, 85.00), 
(3, 13, 72.00); 



INSERT INTO UserRole (user_id, role_id) VALUES
(1, 1),
(2, 1),
(2, 2),
(3, 1),
(4, 3),
(5, 1),
(5, 4);


INSERT INTO Appointment (appointment_time, end_time, notes, type, total_price, user_id, status_id) VALUES
('2025-01-10 10:00:00', '2025-01-10 11:15:00', 'Client requested layers and face-framing. Very happy with results!', 'pre-booked', 110.00, 1, 2),

('2025-01-15 14:00:00', '2025-01-15 15:45:00', 'Walk-in for manicure and pedicure. Used loyalty points for discount.', 'walk-in', 85.00, 2, 2),

('2025-01-20 09:30:00', '2025-01-20 11:00:00', 'Requested Swedish massage with medium pressure. First-time client, explained all procedures.', 'pre-booked', 90.00, 3, 2),

('2025-02-10 11:00:00', '2025-02-10 12:30:00', 'Follow-up hair coloring appointment. Wants to go lighter.', 'pre-booked', 120.00, 1, 1),

('2025-01-25 16:00:00', '2025-01-25 17:15:00', 'Client called to cancel due to emergency. Offered to reschedule.', 'pre-booked', 110.00, 5, 3);


INSERT INTO AppointmentService (appointment_id, service_id) VALUES
(1, 1),  
(1, 3),  

(2, 5),  
(2, 6),  

(3, 8),  

(4, 2),  

(5, 12), 
(5, 4);  


INSERT INTO Payment (amount, method, timestamp, status, appointment_id) VALUES
(110.00, 'Credit Card', '2025-01-10 11:20:00', 'Completed', 1),

(85.00, 'Debit Card', '2025-01-15 15:50:00', 'Completed', 2),

(90.00, 'Cash', '2025-01-20 11:05:00', 'Completed', 3),

(110.00, 'Credit Card', '2025-01-25 16:30:00', 'Refunded', 5);



INSERT INTO Review (rating, comment, created_at, payment_id) VALUES
(5, 'Absolutely loved my haircut! The stylist listened to exactly what I wanted and delivered beyond my expectations. The blowout was perfect and lasted for days. Will definitely be back!', '2025-01-10 18:30:00', 1),

(4, 'Great service overall. The manicure and pedicure were well done and the salon was very clean. Only minor issue was a short wait time, but the quality made up for it. Good value for money.', '2025-01-16 10:15:00', 2),

(5, 'Best massage I have ever had! The therapist was professional and really worked out all my tension. The ambiance was so relaxing. I felt like a new person afterwards. Highly recommend!', '2025-01-20 14:45:00', 3);


INSERT INTO LoyaltyCard (points, user_id) VALUES
(110, 1),

(85, 2),

(90, 3);

