PRAGMA foreign_keys = ON;

CREATE TABLE User (
    user_id INTEGER PRIMARY KEY AUTOINCREMENT,
    first_name TEXT NOT NULL,
    last_name TEXT NOT NULL,
    email TEXT UNIQUE NOT NULL,
    phone_number TEXT,
    gender TEXT,
    birthday TEXT
);

CREATE TABLE Wedding (
    wedding_id INTEGER PRIMARY KEY AUTOINCREMENT,
    date TEXT NOT NULL,
    budget REAL CHECK (budget >= 0),
    notes TEXT,
    user_id INTEGER NOT NULL,
    FOREIGN KEY (user_id) REFERENCES User(user_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Event (
    event_id INTEGER PRIMARY KEY AUTOINCREMENT,
    event_type TEXT NOT NULL,
    date TEXT NOT NULL,
    start_time TEXT NOT NULL,
    end_time TEXT NOT NULL,
    status TEXT NOT NULL,
    wedding_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Guest (
    guest_id INTEGER PRIMARY KEY AUTOINCREMENT,
    first_name TEXT NOT NULL,
    last_name TEXT NOT NULL,
    email TEXT,
    wedding_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Attendance (
    attendance_id INTEGER PRIMARY KEY AUTOINCREMENT,
    status TEXT NOT NULL,
    role TEXT,
    table_number INTEGER,
    guest_id INTEGER NOT NULL,
    event_id INTEGER NOT NULL,
    FOREIGN KEY (guest_id) REFERENCES Guest(guest_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (event_id) REFERENCES Event(event_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Venue_Type (
    type_id INTEGER PRIMARY KEY AUTOINCREMENT,
    type_name TEXT UNIQUE NOT NULL
);

CREATE TABLE Venue (
    venue_id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    city TEXT NOT NULL,
    address TEXT NOT NULL,
    capacity INTEGER,
    price_per_guest REAL,
    type_id INTEGER NOT NULL,
    FOREIGN KEY (type_id) REFERENCES Venue_Type(type_id)
        ON DELETE RESTRICT ON UPDATE CASCADE
);

CREATE TABLE Venue_Booking (
    booking_id INTEGER PRIMARY KEY AUTOINCREMENT,
    date TEXT NOT NULL,
    start_time TEXT NOT NULL,
    end_time TEXT NOT NULL,
    status TEXT NOT NULL,
    wedding_id INTEGER NOT NULL,
    venue_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (venue_id) REFERENCES Venue(venue_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Band (
    band_id INTEGER PRIMARY KEY AUTOINCREMENT,
    band_name TEXT UNIQUE NOT NULL,
    genre TEXT,
    phone_number TEXT
);

CREATE TABLE Band_Booking (
    booking_id INTEGER PRIMARY KEY AUTOINCREMENT,
    date TEXT NOT NULL,
    start_time TEXT NOT NULL,
    end_time TEXT NOT NULL,
    status TEXT NOT NULL,
    wedding_id INTEGER NOT NULL,
    band_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (band_id) REFERENCES Band(band_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Photographer (
    photographer_id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    phone_number TEXT,
    price_per_hour REAL
);

CREATE TABLE Photographer_Booking (
    booking_id INTEGER PRIMARY KEY AUTOINCREMENT,
    date TEXT NOT NULL,
    start_time TEXT NOT NULL,
    end_time TEXT NOT NULL,
    status TEXT NOT NULL,
    wedding_id INTEGER NOT NULL,
    photographer_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (photographer_id) REFERENCES Photographer(photographer_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Church (
    church_id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    city TEXT,
    wedding_id INTEGER UNIQUE NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Registrar (
    registrar_id INTEGER PRIMARY KEY AUTOINCREMENT,
    name TEXT NOT NULL,
    location TEXT
);

CREATE TABLE Registrar_Booking (
    booking_id INTEGER PRIMARY KEY AUTOINCREMENT,
    date TEXT NOT NULL,
    start_time TEXT NOT NULL,
    end_time TEXT NOT NULL,
    status TEXT NOT NULL,
    wedding_id INTEGER NOT NULL,
    registrar_id INTEGER NOT NULL,
    FOREIGN KEY (wedding_id) REFERENCES Wedding(wedding_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (registrar_id) REFERENCES Registrar(registrar_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);

CREATE TABLE Event_RSVP (
    rsvp_id INTEGER PRIMARY KEY AUTOINCREMENT,
    status TEXT NOT NULL,
    response_date TEXT,
    guest_id INTEGER NOT NULL,
    event_id INTEGER NOT NULL,
    FOREIGN KEY (guest_id) REFERENCES Guest(guest_id)
        ON DELETE CASCADE ON UPDATE CASCADE,
    FOREIGN KEY (event_id) REFERENCES Event(event_id)
        ON DELETE CASCADE ON UPDATE CASCADE
);
