SET search_path TO project;

TRUNCATE TABLE
    event_rsvp,
    attendance,
    event,
    guest,
    priest,
    church,
    registrar_booking,
    registrar,
    venue_booking,
    photographer_booking,
    band_booking,
    venue,
    venue_type,
    photographer,
    band,
    wedding,
    "user"
RESTART IDENTITY CASCADE;

INSERT INTO "user"(first_name, last_name, email, phone_number, gender, birthday) VALUES
('Ana', 'Trajkovska', 'ana.trajkovska@gmail.com', '+38970111222', 'Female', '2004-07-12'),
('Stefan', 'Petrovski', 'stefan.petrovski@gmail.com', '+38970333444', 'Male', '2003-11-20');

INSERT INTO wedding("date", budget, notes, user_id) VALUES
('2026-06-20', 8500.00, 'Summer wedding', 1),
('2026-09-05', 12000.00, 'Elegant indoor wedding', 2);

INSERT INTO church(name, location, contact, wedding_id) VALUES
('St. Clement Church', 'Skopje', 'contact@church.mk', 1),
('St. Panteleimon', 'Nerezi', 'info@church.mk', 2);

INSERT INTO priest(name, contact, church_id) VALUES
('Father Nikola', '+38970123456', 1),
('Father Petar', '+38970222333', 2);

INSERT INTO venue_type(type_name) VALUES
('Restaurant'), ('Wedding Hall'), ('Outdoor Garden');

INSERT INTO venue(name, location, city, address, capacity, menu, phone_number, price_per_guest, type_id) VALUES
('Lakeside Garden', 'Matka', 'Skopje', 'Matka 12', 200, 'Garden menu', '+38971123456', 35, 3),
('Royal Hall', 'Centar', 'Skopje', 'Main St 5', 350, 'Full menu', '+38972234567', 45, 2);

INSERT INTO photographer(name, email, phone_number, price_per_hour) VALUES
('Luna Studio', 'luna@studio.mk', '+38970101010', 55),
('Golden Frame', 'golden@frame.mk', '+38970202020', 65);

INSERT INTO band(band_name, genre, equipment, phone_number, price_per_hour) VALUES
('Wedding Vibes', 'Pop', 'Sound + lights', '+38970909090', 80),
('Balkan Groove', 'Traditional', 'Full instruments', '+38970707070', 95);

INSERT INTO registrar(name, contact, location, working_hours) VALUES
('Skopje Civil Registry', '+38970123456', 'Skopje', '08:00-16:00'),
('Centar Registry', '+38970222333', 'Skopje', '09:00-17:00');

INSERT INTO venue_booking("date", start_time, end_time, status, price, venue_id, wedding_id) VALUES
('2026-06-20', '16:00', '23:00', 'confirmed', 7000, 1, 1),
('2026-09-05', '17:00', '23:30', 'confirmed', 9500, 2, 2);

INSERT INTO photographer_booking("date", start_time, end_time, status, photographer_id, wedding_id) VALUES
('2026-06-20', '14:00', '22:00', 'confirmed', 1, 1),
('2026-09-05', '12:00', '21:00', 'pending', 2, 2);

INSERT INTO band_booking("date", start_time, end_time, status, band_id, wedding_id) VALUES
('2026-06-20', '18:00', '23:00', 'confirmed', 1, 1),
('2026-09-05', '19:00', '23:30', 'confirmed', 2, 2);

INSERT INTO registrar_booking("date", start_time, end_time, status, registrar_id) VALUES
('2026-06-20', '10:00', '10:30', 'confirmed', 1),
('2026-09-05', '11:00', '11:30', 'confirmed', 2);

INSERT INTO event(event_type, "date", start_time, end_time, status, wedding_id) VALUES
('Ceremony', '2026-06-20', '12:00', '13:00', 'scheduled', 1),
('Reception', '2026-06-20', '16:00', '23:00', 'scheduled', 1);

INSERT INTO guest(first_name, last_name, email, wedding_id) VALUES
('Ana', 'Markovska', 'ana.m@gmail.com', 1),
('Daniel', 'Stojanov', 'daniel.s@gmail.com', 1);

INSERT INTO event_rsvp(status, response_date, guest_id, event_id) VALUES
('accepted', '2026-05-15', 1, 1),
('accepted', '2026-05-15', 2, 2);

INSERT INTO attendance(status, table_number, role, guest_id, event_id) VALUES
('attending', 5, 'Guest', 1, 2),
('attending', 7, 'Guest', 2, 2);
