SET search_path TO project;

TRUNCATE TABLE
    event_rsvp,
    attendance,
    event,
    guest,
    priest,
    church,
    venue_booking,
    photographer_booking,
    band_booking,
    venue,
    venue_type,
    photographer,
    band,
    wedding,
    "user"
RESTART IDENTITY CASCADE;

INSERT INTO "user"(first_name, last_name, email, phone_number, gender, birthday) VALUES
('Ana', 'Trajkovska', 'ana.trajkovska@gmail.com', '+38970111222', 'Female', '2004-07-12'),
('Stefan', 'Petrovski', 'stefan.petrovski@gmail.com', '+38970333444', 'Male', '2003-11-20'),
('Marija', 'Todorova', 'marija.todorova@gmail.com', '+38970999888', 'Female', '2004-03-01');

INSERT INTO wedding("date", budget, notes, user_id) VALUES
('2026-06-20', 8500.00, 'Summer wedding with outdoor reception', 1),
('2026-09-05', 12000.00, 'Elegant indoor wedding with live band', 2);

INSERT INTO church(name, location, contact, wedding_id) VALUES
('St. Clement of Ohrid Church', 'Skopje', 'contact@stclement.mk', 1),
('St. Panteleimon Church', 'Nerezi - Skopje', 'info@panteleimon.mk', 2);

INSERT INTO priest(name, contact, church_id) VALUES
('Father Nikola', '+38970123456', 1),
('Father Petar', '+38970222333', 2);

INSERT INTO venue_type(type_name) VALUES
('Restaurant'),
('Wedding Hall'),
('Outdoor Garden');

INSERT INTO venue(name, location, city, address, capacity, menu, phone_number, price_per_guest, type_id) VALUES
('Lakeside Garden Venue', 'Matka Canyon', 'Skopje', 'Matka Road 12', 200, 'Garden menu + drinks package', '+38971123456', 35.00, 3),
('Royal Wedding Hall', 'Centar', 'Skopje', 'Macedonia St. 55', 350, 'Full catering + dessert table', '+38972234567', 45.00, 2),
('Bella Restaurant', 'Karposh', 'Skopje', 'Partizanski Odredi 101', 150, 'Traditional + modern menu options', '+38973345678', 28.00, 1);

INSERT INTO photographer(name, email, phone_number, price_per_hour) VALUES
('Luna Studio', 'luna@studio.mk', '+38970101010', 55.00),
('Golden Frame', 'golden@frame.mk', '+38970202020', 65.00);

INSERT INTO band(band_name, genre, equipment, phone_number, price_per_hour) VALUES
('The Wedding Vibes', 'Pop', 'Sound system + lights', '+38970909090', 80.00),
('Balkan Groove', 'Traditional', 'Full instruments + microphones', '+38970707070', 95.00);

INSERT INTO venue_booking("date", start_time, end_time, status, price, venue_id, wedding_id) VALUES
('2026-06-20', '16:00', '23:00', 'confirmed', 7000.00, 1, 1),
('2026-09-05', '17:00', '23:30', 'confirmed', 9500.00, 2, 2);

INSERT INTO photographer_booking("date", start_time, end_time, status, photographer_id, wedding_id) VALUES
('2026-06-20', '14:00', '22:00', 'confirmed', 1, 1),
('2026-09-05', '12:00', '21:00', 'pending', 2, 2);

INSERT INTO band_booking("date", start_time, end_time, status, band_id, wedding_id) VALUES
('2026-06-20', '18:00', '23:00', 'confirmed', 1, 1),
('2026-09-05', '19:00', '23:30', 'confirmed', 2, 2);

INSERT INTO event(event_type, "date", start_time, end_time, status, wedding_id) VALUES
('Church Ceremony', '2026-06-20', '12:00', '13:00', 'scheduled', 1),
('Reception',       '2026-06-20', '16:00', '23:00', 'scheduled', 1),
('Civil Registry',  '2026-09-05', '11:00', '12:00', 'scheduled', 2),
('Party',           '2026-09-05', '17:00', '23:30', 'scheduled', 2);

INSERT INTO guest(first_name, last_name, email, wedding_id) VALUES
('Ana', 'Markovska', 'ana.markovska@gmail.com', 1),
('Daniel', 'Stojanov', 'daniel.stojanov@gmail.com', 1),
('Elena', 'Petrova', 'elena.petrova@gmail.com', 1),
('Martin', 'Iliev', 'martin.iliev@gmail.com', 2),
('Sofia', 'Ristova', 'sofia.ristova@gmail.com', 2);

INSERT INTO event_rsvp(status, response_date, guest_id, event_id) VALUES
('accepted', '2026-05-15', 1, 1),
('accepted', '2026-05-15', 1, 2),
('declined', '2026-05-20', 2, 1),
('accepted', '2026-05-21', 2, 2),
('accepted', '2026-05-18', 3, 2),
('accepted', '2026-08-10', 4, 3),
('accepted', '2026-08-10', 4, 4),
('pending',  '2026-08-15', 5, 4);

INSERT INTO attendance(status, table_number, role, guest_id, event_id) VALUES
('attending', NULL, 'Guest', 1, 1),
('attending', 5, 'Guest', 1, 2),
('not_attending', NULL, 'Guest', 2, 1),
('attending', 7, 'Guest', 2, 2),
('attending', 3, 'Maid of Honor', 3, 2),
('attending', NULL, 'Guest', 4, 3),
('attending', 2, 'Best Man', 4, 4),
('attending', 6, 'Guest', 5, 4);
