INSERT INTO Users (Username, FirstName, LastName, Address, Phone, Password, Email, Role)
VALUES 
    ('john_doe', 'John', 'Doe', '123 Main St', 1234567890, 'password123', 'john@example.com', 'Admin'),
    ('jane_smith', 'Jane', 'Smith', '456 Elm St', 9876543210, 'password456', 'jane@example.com', 'Member'),
    ('alice_johnson', 'Alice', 'Johnson', '789 Pine St', 1122334455, 'password789', 'alice@example.com', 'Member'),
    ('bob_brown', 'Bob', 'Brown', '101 Oak St', 2233445566, 'password101', 'bob@example.com', 'Member'),
    ('charlie_williams', 'Charlie', 'Williams', '202 Maple St', 4455667788, 'password202', 'charlie@example.com', 'Member');

INSERT INTO Member (Expired_Date, Membership_Status, UserID)
VALUES 
    ('2025-12-31', 'Active', 1),
    ('2024-06-30', 'Inactive', 2),
    ('2025-01-15', 'Suspended', 3),
    ('2026-03-10', 'Active', 4),
    ('2024-09-20', 'Active', 5);

INSERT INTO Book (ISBN, Title, Genre, PublishedYear, Description, CoverImage, TotalCopies) 
VALUES 
('9780765376459', 'A Darker Shade of Magic', 'Fantasy', 2015, 'In a world where parallel Londons exist, a magician with a rare ability to travel between them becomes entangled in a dangerous conspiracy.', 'book1.jpg', 10),
('9780735223630', 'The Invisible Life of Addie LaRue', 'Fiction', 2020, 'A woman makes a pact to live forever but is forgotten by everyone she meets.', 'book2.jpg', 9),
('9780765387462', 'A Conjuring of Light', 'Fantasy', 2017, 'The epic conclusion to the Shades of Magic series, where the fate of the Londons hangs in the balance.', 'book3.jpg', 7),
('9780765387493', 'Vicious', 'Science Fiction', 2013, 'Two college students discover how to develop superhuman abilities, but their friendship spirals into a dark rivalry.', 'book4.jpg', 9),
('9780765387523', 'Vengeful', 'Science Fiction', 2018, 'A sequel to Vicious, exploring the intricate dynamics of power and revenge in a world of extraordinary abilities.', 'book5.jpg', 6), 
('9780140449136', 'Crime and Punishment', 'Classic Literature', 1866, 'A psychological exploration of morality and redemption, following a young man who commits a murder in pursuit of a higher purpose.', 'book6.jpg', 10),
('9780140449242', 'The Brothers Karamazov', 'Classic Literature', 1880, 'An epic tale of faith, doubt, and family conflict, revolving around the murder of a father and the spiritual struggles of his sons.', 'book7.jpg', 8),
('9780140449556', 'The Idiot', 'Classic Literature', 1869, 'The story of Prince Myshkin, a man whose innocence and goodness lead to tragic consequences in a corrupt society.', 'book8.jpg', 7),
('9780140447910', 'Notes from Underground', 'Philosophical Fiction', 1864, 'A darkly humorous and profound narrative that delves into the mind of an isolated, bitter man in 19th-century Russia.', 'book9.jpg', 6),
('9780140447934', 'Demons', 'Classic Literature', 1872, 'A political and social satire about a small town overtaken by nihilistic revolutionaries, showcasing Dostoevsky’s critique of radical ideologies.', 'book10.jpg', 5),
('9780060837020', 'The Bell Jar', 'Fiction', 1963, 'A semi-autobiographical novel about a young woman’s struggles with mental health and identity in 1950s America.', 'book11.jpg', 10),
('9780060931728', 'Ariel', 'Poetry', 1965, 'A groundbreaking collection of poems that explore themes of love, death, and selfhood.', 'book12.jpg', 8),
('9780571236091', 'The Collected Poems', 'Poetry', 1981, 'A comprehensive anthology of Sylvia Plath’s poetic works, showcasing her evolution as a poet.', 'book13.jpg', 7),
('9780374115357', 'Johnny Panic and the Bible of Dreams', 'Short Stories', 1977, 'A posthumous collection of short stories and essays highlighting Plath’s literary versatility.', 'book14.jpg', 6),
('9780060931735', 'Crossing the Water', 'Poetry', 1971, 'A collection of poems that reflect Sylvia Plath’s transitional period as a writer, balancing despair and clarity.', 'book15.jpg', 5),
('9780679732684', 'The Stranger', 'Philosophical Fiction', 1942, 'A classic existential novel that follows Meursault, a man who commits a senseless murder, reflecting on the absurdity of life.', 'book16.jpg', 10),
('9780140187532', 'The Plague', 'Philosophical Fiction', 1947, 'A novel set in a fictional Algerian town during a plague outbreak, exploring themes of human suffering and solidarity.', 'book17.jpg', 8),
('9780679720209', 'The Myth of Sisyphus', 'Philosophy', 1942, 'An essay where Camus explores the idea of the absurd and the human desire for meaning in a meaningless universe.', 'book18.jpg', 7),
('9780140442288', 'The Fall', 'Philosophical Fiction', 1956, 'A novel set in Amsterdam where a former lawyer confesses his moral failings, contemplating guilt, innocence, and human nature.', 'book19.jpg', 6),
('9780679764005', 'Exile and the Kingdom', 'Short Stories', 1957, 'A collection of six short stories that delve into themes of isolation, identity, and the human condition.', 'book20.jpg', 5),
('9780486284704', 'Faust', 'Drama', 1808, 'A tragic play in two parts, exploring themes of ambition, knowledge, and the quest for meaning, as Faust makes a pact with the devil.', 'book21.jpg', 10),
('9780140449136', 'The Sorrows of Young Werther', 'Romantic Literature', 1774, 'A novel about a young man whose unrequited love leads him to despair and ultimately, suicide, reflecting Romantic ideals.', 'book22.jpg', 9),
('9780199237760', 'Wilhelm Meister’s Apprenticeship', 'Bildungsroman', 1795, 'A novel exploring the development of the protagonist’s character as he seeks his place in the world and understanding of his purpose.', 'book23.jpg', 8),
('9780486451220', 'Elective Affinities', 'Fiction', 1809, 'A novel about a love triangle and the complicated nature of human relationships, reflecting on passion, marriage, and social obligations.', 'book24.jpg', 7),
('9780140448184', 'Italian Journey', 'Travel Writing', 1816, 'A collection of letters written by Goethe during his travels through Italy, offering insights into his observations and experiences.', 'book25.jpg', 6),
('9781401232475', 'Watchmen', 'Graphic Novel', 1986, 'A groundbreaking graphic novel that deconstructs the superhero genre, exploring power, morality, and the nature of heroism.', 'comic1.jpg', 10),
('9781563892393', 'The Sandman: Preludes and Nocturnes', 'Graphic Novel', 1991, 'The first volume of Neil Gaiman’s dark fantasy series that follows Dream, one of the Endless, through a journey of myth and mystery.', 'comic2.jpg', 9),
('9781401234318', 'Batman: The Killing Joke', 'Graphic Novel', 1988, 'A controversial graphic novel that explores the Joker’s origins and his psychological battle with Batman.', 'comic3.jpg', 8),
('9780061122415', 'The Road', 'Graphic Novel', 2006, 'A post-apocalyptic novel about a father and his young son struggling to survive in a desolate world.', 'comic4.jpg', 8),
('9780785117711', 'X-Men: Days of Future Past', 'Graphic Novel', 1981, 'A time-traveling storyline where the X-Men attempt to change the future and prevent the rise of mutant-destroying Sentinels.', 'comic5.jpg', 6),
('9781612620244', 'Sword Art Online', 'Manga', 2009, 'A virtual reality MMORPG traps players inside, and the protagonist, Kirito, must clear the game to escape while facing battles and moral dilemmas.', 'manga1.jpg', 10),
('9781975322937', 'Frieren: Beyond Journey’s End', 'Manga', 2020, 'Following the defeat of the Demon King, a long-lived elf named Frieren embarks on a journey to reflect on her past and the bonds she shared with her companions.', 'manga2.jpg', 9),
('9781632360007', 'A Silent Voice', 'Manga', 2011, 'A story of redemption, following a boy who bullied a deaf girl in elementary school and seeks to make amends years later.', 'manga3.jpg', 8),
('9781975327499', 'Re:Zero - Starting Life in Another World', 'Manga', 2012, 'A young man is transported to a fantasy world, where he discovers that every time he dies, he is brought back to life, with the goal of saving his friends.', 'manga4.jpg', 7),
('9781632363527', 'Your Name', 'Manga', 2016, 'Two teenagers from different parts of Japan mysteriously swap bodies and must work together to uncover the secret behind their connection.', 'manga5.jpg', 6);

INSERT INTO Book_Details (BookID, Format, Language, Publisher, Pages) 
VALUES 
(1, 'Hardcover', 'English', 'Tor Books', 400),
(2, 'Hardcover', 'English', 'Viking', 440),
(3, 'Hardcover', 'English', 'Tor Books', 624),
(4, 'Paperback', 'English', 'V.E. Schwab', 368),
(5, 'Paperback', 'English', 'V.E. Schwab', 464),
(6, 'Paperback', 'English', 'Penguin Classics', 430),
(7, 'Paperback', 'English', 'Penguin Classics', 796),
(8, 'Paperback', 'English', 'Penguin Classics', 656),
(9, 'Paperback', 'English', 'Penguin Classics', 440),
(10, 'Paperback', 'English', 'Penguin Classics', 640),
(11, 'Paperback', 'English', 'Harper & Row', 288),
(12, 'Hardcover', 'English', 'HarperCollins', 132),
(13, 'Paperback', 'English', 'Faber and Faber', 280),
(14, 'Hardcover', 'English', 'Harper & Row', 220),
(15, 'Paperback', 'English', 'Faber and Faber', 144),
(16, 'Paperback', 'English', 'Vintage', 123),
(17, 'Paperback', 'English', 'Vintage', 450),
(18, 'Paperback', 'English', 'Vintage', 112),
(19, 'Hardcover', 'English', 'Vintage', 320),
(20, 'Paperback', 'English', 'Vintage', 230),
(21, 'Hardcover', 'English', 'Penguin Classics', 800),
(22, 'Paperback', 'English', 'Penguin Classics', 400),
(23, 'Paperback', 'English', 'Penguin Classics', 720),
(24, 'Paperback', 'English', 'Penguin Classics', 460),
(25, 'Paperback', 'English', 'Penguin Classics', 300),
(26, 'Hardcover', 'English', 'DC Comics', 416),
(27, 'Hardcover', 'English', 'DC Comics', 256),
(28, 'Paperback', 'English', 'DC Comics', 48),
(29, 'Hardcover', 'English', 'Vintage International', 287),
(30, 'Paperback', 'English', 'Marvel Comics', 160),
(31, 'Paperback', 'English', 'Yen Press', 224),
(32, 'Paperback', 'English', 'Kodansha Comics', 240),
(33, 'Paperback', 'English', 'Kodansha Comics', 198),
(34, 'Paperback', 'English', 'Yen Press', 224),
(35, 'Paperback', 'English', 'Shogakukan', 225);

INSERT INTO Book_Copies (BookID, Condition)
VALUES
(1, 'New'), (1, 'Good'), (1, 'Good'), (1, 'New'), (1, 'Good'),
(1, 'Good'), (1, 'Damaged'), (1, 'Good'), (1, 'New'), (1, 'Good'),
(2, 'New'), (2, 'Good'), (2, 'Good'), (2, 'New'), (2, 'Good'),
(2, 'Damaged'), (2, 'Good'), (2, 'Good'), (2, 'New'),
(3, 'Good'), (3, 'New'), (3, 'Good'), (3, 'Damaged'),
(3, 'Good'), (3, 'New'), (3, 'Good'),
(4, 'New'), (4, 'Good'), (4, 'Good'), (4, 'New'), 
(4, 'Good'), (4, 'Damaged'), (4, 'Good'), (4, 'New'), (4, 'Good'),
(5, 'New'), (5, 'Good'), (5, 'Damaged'), (5, 'Good'),
(5, 'New'), (5, 'Good'),
(6, 'New'), (6, 'Good'), (6, 'Good'), (6, 'New'), (6, 'Good'),
(6, 'Damaged'), (6, 'Good'), (6, 'New'), (6, 'Good'), (6, 'Good'),
(7, 'New'), (7, 'Good'), (7, 'Damaged'), (7, 'Good'),
(7, 'New'), (7, 'Good'), (7, 'Good'), (7, 'New'),
(8, 'New'), (8, 'Good'), (8, 'Damaged'), (8, 'Good'),
(8, 'New'), (8, 'Good'), (8, 'Good'),
(9, 'New'), (9, 'Good'), (9, 'Damaged'), (9, 'Good'),
(9, 'New'), (9, 'Good'),
(10, 'New'), (10, 'Good'), (10, 'Damaged'), (10, 'Good'),
(10, 'New'),
(11, 'New'), (11, 'Good'), (11, 'Good'), (11, 'New'), (11, 'Good'),
(11, 'Damaged'), (11, 'Good'), (11, 'New'), (11, 'Good'), (11, 'Good'),
(12, 'New'), (12, 'Good'), (12, 'Damaged'), (12, 'Good'),
(12, 'New'), (12, 'Good'), (12, 'Good'), (12, 'New'),
(13, 'New'), (13, 'Good'), (13, 'Damaged'), (13, 'Good'),
(13, 'New'), (13, 'Good'), (13, 'Good'),
(14, 'New'), (14, 'Good'), (14, 'Damaged'), (14, 'Good'),
(14, 'New'), (14, 'Good'),
(15, 'New'), (15, 'Good'), (15, 'Damaged'), (15, 'Good'),
(15, 'New'),
(16, 'New'), (16, 'Good'), (16, 'Good'), (16, 'New'), (16, 'Good'),
(16, 'Damaged'), (16, 'Good'), (16, 'New'), (16, 'Good'), (16, 'Good'),
(17, 'New'), (17, 'Good'), (17, 'Damaged'), (17, 'Good'),
(17, 'New'), (17, 'Good'), (17, 'Good'), (17, 'New'),
(18, 'New'), (18, 'Good'), (18, 'Damaged'), (18, 'Good'),
(18, 'New'), (18, 'Good'), (18, 'Good'),
(19, 'New'), (19, 'Good'), (19, 'Damaged'), (19, 'Good'),
(19, 'New'), (19, 'Good'),
(20, 'New'), (20, 'Good'), (20, 'Damaged'), (20, 'Good'),
(20, 'New'),
(21, 'New'), (21, 'Good'), (21, 'Good'), (21, 'New'), (21, 'Good'),
(21, 'Damaged'), (21, 'Good'), (21, 'New'), (21, 'Good'), (21, 'Good'),
(22, 'New'), (22, 'Good'), (22, 'Damaged'), (22, 'Good'),
(22, 'New'), (22, 'Good'), (22, 'Good'), (22, 'New'), (22, 'Good'),
(23, 'New'), (23, 'Good'), (23, 'Damaged'), (23, 'Good'),
(23, 'New'), (23, 'Good'), (23, 'Good'), (23, 'Good'),
(24, 'New'), (24, 'Good'), (24, 'Damaged'), (24, 'Good'),
(24, 'New'), (24, 'Good'), (24, 'Good'),
(25, 'New'), (25, 'Good'), (25, 'Damaged'), (25, 'Good'),
(25, 'New'), (25, 'Good'),
(26, 'New'), (26, 'Good'), (26, 'Good'), (26, 'New'), (26, 'Good'),
(26, 'Damaged'), (26, 'Good'), (26, 'New'), (26, 'Good'), (26, 'Good'),
(27, 'New'), (27, 'Good'), (27, 'Damaged'), (27, 'Good'),
(27, 'New'), (27, 'Good'), (27, 'Good'), (27, 'New'), (27, 'Good'),
(28, 'New'), (28, 'Good'), (28, 'Damaged'), (28, 'Good'),
(28, 'New'), (28, 'Good'), (28, 'Good'), (28, 'Good'),
(29, 'New'), (29, 'Good'), (29, 'Damaged'), (29, 'Good'),
(29, 'New'), (29, 'Good'), (29, 'Good'),
(30, 'New'), (30, 'Good'), (30, 'Damaged'), (30, 'Good'),
(30, 'New'), (30, 'Good'),
(31, 'New'), (31, 'Good'), (31, 'Good'), (31, 'New'), (31, 'Good'),
(31, 'Damaged'), (31, 'Good'), (31, 'New'), (31, 'Good'), (31, 'Good'),
(32, 'New'), (32, 'Good'), (32, 'Damaged'), (32, 'Good'),
(32, 'New'), (32, 'Good'), (32, 'Good'), (32, 'New'), (32, 'Good'),
(33, 'New'), (33, 'Good'), (33, 'Damaged'), (33, 'Good'),
(33, 'New'), (33, 'Good'), (33, 'Good'), (33, 'Good'),
(34, 'New'), (34, 'Good'), (34, 'Damaged'), (34, 'Good'),
(34, 'New'), (34, 'Good'), (34, 'Good'),
(35, 'New'), (35, 'Good'), (35, 'Damaged'), (35, 'Good'),
(35, 'New'), (35, 'Good');

INSERT INTO Author (FirstName, LastName, Nationality, DateOfBirth, Author_description, Author_image)
VALUES
('V.E.', 'Schwab', 'American', '1987-07-07', 'V.E. Schwab is a best-selling author known for her work in fantasy, science fiction, and horror genres. She is best known for her Shades of Magic series and has written several acclaimed novels.', 'author1.jpg'),
('Fyodor', 'Dostoevsky', 'Russian', '1821-11-11', 'Fyodor Dostoevsky was a Russian novelist and philosopher, known for his deep psychological insights and explorations of the human condition. His works often focus on themes of morality, existentialism, and spirituality.', 'author2.jpg'),
('Sylvia', 'Plath', 'American', '1932-10-27', 'Sylvia Plath was an American poet, novelist, and short-story writer, best known for her confessional poetry and her novel, "The Bell Jar." She is recognized for her powerful and emotionally raw writing, focusing on themes of identity, mental illness, and death.', 'author3.jpg'),
('Albert', 'Camus', 'French', '1913-11-07', 'Albert Camus was a French-Algerian philosopher, author, and journalist, best known for his works on the philosophy of the absurd, including "The Stranger" and "The Myth of Sisyphus."', 'author4.jpg'),
('Johann Wolfgang', 'Goethe', 'German', '1749-08-28', 'Johann Wolfgang von Goethe was a German writer, poet, and philosopher. He is considered one of the greatest figures in Western literature, with works like "Faust" and "The Sorrows of Young Werther."', 'author5.jpg'),
('Alan', 'Moore', 'British', '1953-11-18', 'Alan Moore is a British writer, known for his groundbreaking work in the graphic novel genre, including "Watchmen" and "V for Vendetta."', 'author6.jpg'),
('Neil', 'Gaiman', 'British', '1960-11-10', 'Neil Gaiman is a British author known for his work in fantasy, horror, and mythology, including the acclaimed "Sandman" series and "American Gods."', 'author7.jpg'),
('Manu', 'Larcenet', 'French', '1969-11-09', 'Manu Larcenet is a French comic book artist and writer, known for his work on graphic novels such as *Le Combat Ordinaire* and *Blast*. His works often explore themes of existentialism, personal struggles, and the complexities of human relationships.', 'author8.jpg'),
('Chris', 'Claremont', 'British', '1950-11-30', 'Chris Claremont is a British-American writer, known for his influential work on Marvel Comics’ X-Men series, including the storyline "Days of Future Past."', 'author9.jpg'),
('Reki', 'Kawahara', 'Japanese', '1974-08-17', 'Reki Kawahara is a Japanese author best known for his light novel series *Sword Art Online* and *Accel World*. His works often explore virtual reality, gaming, and the psychological impact of immersive digital worlds.', 'author10.jpg'),
('Kanehito', 'Yamada', 'Japanese', '1993-01-01', 'Kanehito Yamada is a Japanese author best known for his work on the manga *Frieren: Beyond Journey’s End*, a unique series that blends fantasy with deep emotional storytelling, focusing on themes of time, memory, and the passage of life.', 'author11.jpg'),
('Yoshitoki', 'Oima', 'Japanese', '1989-09-15', 'Yoshitoki Oima is a Japanese manga artist, best known for creating the critically acclaimed series "A Silent Voice," which deals with themes of redemption and bullying.', 'author12.jpg'),
('Tappei', 'Nagatsuki', 'Japanese', '1987-04-19', 'Tappei Nagatsuki is a Japanese light novel author best known for his work "Re:Zero - Starting Life in Another World," a series that explores alternate realities and the consequences of death.', 'author13.jpg'),
('Makoto', 'Shinkai', 'Japanese', '1973-02-09', 'Makoto Shinkai is a Japanese film director and novelist, famous for creating the anime film "Your Name," which explores themes of time, fate, and love.', 'author14.jpg');

INSERT INTO Book_Author (BookID, AuthorID)
VALUES
(1, 1),  -- A Darker Shade of Magic -> V.E. Schwab
(2, 1),  -- The Invisible Life of Addie LaRue -> V.E. Schwab
(3, 1),  -- A Conjuring of Light -> V.E. Schwab
(4, 1),  -- Vicious -> V.E. Schwab
(5, 1),  -- Vengeful -> V.E. Schwab
(6, 2),  -- Crime and Punishment -> Fyodor Dostoevsky
(7, 2),  -- The Brothers Karamazov -> Fyodor Dostoevsky
(8, 2),  -- The Idiot -> Fyodor Dostoevsky
(9, 2),  -- Notes from Underground -> Fyodor Dostoevsky
(10, 2), -- Demons -> Fyodor Dostoevsky
(11, 3), -- The Bell Jar -> Sylvia Plath
(12, 3), -- Ariel -> Sylvia Plath
(13, 3), -- The Collected Poems -> Sylvia Plath
(14, 3), -- Johnny Panic and the Bible of Dreams -> Sylvia Plath
(15, 3), -- Crossing the Water -> Sylvia Plath
(16, 4), -- The Stranger -> Albert Camus
(17, 4), -- The Plague -> Albert Camus
(18, 4), -- The Myth of Sisyphus -> Albert Camus
(19, 4), -- The Fall -> Albert Camus
(20, 4), -- Exile and the Kingdom -> Albert Camus
(21, 5), -- Faust -> Johann Wolfgang Goethe
(22, 5), -- The Sorrows of Young Werther -> Johann Wolfgang Goethe
(23, 5), -- Wilhelm Meister’s Apprenticeship -> Johann Wolfgang Goethe
(24, 5), -- Elective Affinities -> Johann Wolfgang Goethe
(25, 5), -- Italian Journey -> Johann Wolfgang Goethe
(26, 6), -- Watchmen -> Alan Moore
(27, 7), -- The Sandman: Preludes and Nocturnes -> Neil Gaiman
(28, 6), -- Batman: The Killing Joke -> Alan Moore
(29, 8), -- The Road -> Manu Larcenet
(30, 9), -- X-Men: Days of Future Past -> Chris Claremont
(31, 10), -- Sword Art Online -> Reki Kawahara
(32, 11), -- Frieren: Beyond Journey’s End -> Kanehito Yamada
(33, 12), -- A Silent Voice -> Yoshitoki Oima
(34, 13), -- Re:Zero - Starting Life in Another World -> Tappei Nagatsuki
(35, 14); -- Your Name -> Makoto Shinkai
   
   
INSERT INTO Loan (LoanDate, ReturnDate, Status, BookCopyID, MemberID)
VALUES
    ('2024-02-10', '2024-03-10', 'Overdue', 6, 2),
    ('2024-03-01', '2024-04-01', 'Returned', 7, 2),
    ('2024-03-15', '2024-04-15', 'Overdue', 8, 2),
    ('2024-04-01', '2024-05-01', 'Returned', 9, 2),
    ('2024-04-10', '2024-05-10', 'Overdue', 10, 2),
    ('2024-12-26', '2025-01-09', 'On Time', 11, 4),
    ('2024-02-18', '2024-03-18', 'Returned', 12, 4),
    ('2024-12-26', '2025-01-09', 'On Time', 13, 4),
    ('2024-03-15', '2024-04-15', 'Returned', 14, 4),
    ('2024-12-15', '2024-12-29', 'Soon', 15, 4),
    ('2024-04-10', '2024-05-10', 'Returned', 16, 4),
    ('2024-01-25', '2024-02-25', 'Overdue', 17, 5),
    ('2024-02-12', '2024-03-12', 'Returned', 18, 5),
    ('2024-02-20', '2024-03-20', 'Overdue', 19, 5),
    ('2024-03-05', '2024-04-05', 'Returned', 20, 5),
    ('2024-03-25', '2024-04-25', 'Overdue', 21, 5),
    ('2024-04-01', '2024-05-01', 'Returned', 22, 5);


INSERT INTO Fine (FineAmount, FineDate, Status, LoanID)
VALUES
    (5, '2024-03-12', 'Unpaid', 1),  
    (5, '2024-03-19', 'Unpaid', 2),  
    (5, '2024-04-02', 'Unpaid', 3), 
    (5, '2024-04-01', 'Unpaid', 4),  
    (5, '2024-04-15', 'Unpaid', 5), 
    (5, '2024-03-20', 'Unpaid', 6), 
    (5, '2024-04-01', 'Unpaid', 7),
    (5, '2024-04-05', 'Unpaid', 8), 
    (5, '2024-04-10', 'Unpaid', 9),
    (5, '2024-04-15', 'Unpaid', 10); 
   
INSERT INTO FinePayment (PaymentDate, PaymentAmount, FineID)
VALUES
    ('2024-03-15', 5, 1),  
    ('2024-03-25', 5, 2), 
    ('2024-04-05', 5, 3),  
    ('2024-04-10', 5, 4),  
    ('2024-04-25', 5, 6), 
    ('2024-03-30', 5, 7), 
    ('2024-04-20', 5, 8), 
    ('2024-04-25', 5, 9); 

   
INSERT INTO Cart (BookID, MemberID)
VALUES
    (6, 2),
    (7, 2),
    (8, 4),
    (9, 4),
    (10, 5)




