﻿using Npgsql;
using NpgsqlTypes;

class BusnGo
{
    // Connection string with schema set to project_v3
    static string connStr = "Host=localhost;Port=9999;Database=db_202425z_va_prj_busngo;Username=db_202425z_va_prj_busngo_owner;Password=cb67b5e4a198";

    // Class to store session information
    class UserSession
    {
        public long UserId { get; set; }
        public string Role { get; set; } // "patnik", "vozac", "konduktor", or "admin"
        public bool IsAdmin { get; set; }
    }

    static void Main()
    {
        using var conn = new NpgsqlConnection(connStr);
        try
        {
            conn.Open();
            // Set schema search path to project_v3
            using (var cmd = new NpgsqlCommand("SET search_path TO project_v3, public", conn))
            {
                cmd.ExecuteNonQuery();
            }
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Connection error: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
            return;
        }

        // Start as admin by default for testing
        var session = new UserSession
        {
            UserId = 0, // Default admin ID (not tied to a specific user)
            Role = "admin",
            IsAdmin = true
        };
        Console.WriteLine("Started as Admin for testing.");

        // Main menu loop
        while (true)
        {
            DisplayMenu(session);
            Console.Write("Choose: ");
            var choice = Console.ReadLine();

            switch (choice)
            {
                case "1" when session.Role == "patnik" || session.IsAdmin:
                    BuyTicket(conn);
                    break;
                case "2" when session.Role == "patnik" || session.IsAdmin:
                    StartRide(conn);
                    break;
                case "3" when session.Role == "vozac" || session.IsAdmin:
                    StartBusRoute(conn);
                    break;
                case "4" when session.Role == "konduktor" || session.IsAdmin:
                    DoControl(conn);
                    break;
                case "5" when session.Role == "konduktor" || session.IsAdmin:
                    WriteFine(conn);
                    break;
                case "6" when session.IsAdmin:
                    RegisterPassenger(conn);
                    break;
                case "7" when session.IsAdmin:
                    RegisterWorker(conn, "vozac");
                    break;
                case "8" when session.IsAdmin:
                    RegisterWorker(conn, "konduktor");
                    break;
                case "9" when session.IsAdmin:
                    ShowView(conn);
                    break;
                case "10": // Login as another user
                    var newSession = Login(conn);
                    session = newSession ?? session; // Revert to admin if login fails
                    if (newSession != null)
                        Console.WriteLine($"Logged in as {session.Role}{(session.IsAdmin ? " (Admin)" : "")}.");
                    else
                        Console.WriteLine("Login failed, continuing as Admin.");
                    break;
                case "0":
                    return;
                default:
                    Console.WriteLine("Invalid choice or unauthorized action.");
                    break;
            }
        }
    }

    // Login function (optional for testing)
    static UserSession Login(NpgsqlConnection conn)
    {
        Console.Write("Email: ");
        var email = Console.ReadLine();
        Console.Write("Password: ");
        var password = Console.ReadLine();

        using var cmd = new NpgsqlCommand(
            @"SELECT k.k_id, k.k_is_admin, 
                     CASE 
                         WHEN p.k_id IS NOT NULL THEN 'patnik'
                         WHEN v.k_id IS NOT NULL THEN 'vozac'
                         WHEN knd.k_id IS NOT NULL THEN 'konduktor'
                         ELSE 'unknown'
                     END AS role
              FROM Korisnik k
              LEFT JOIN Patnik p ON k.k_id = p.k_id
              LEFT JOIN Vraboten v ON k.k_id = v.k_id
              LEFT JOIN Vozac vz ON v.k_id = vz.k_id
              LEFT JOIN Konduktor knd ON v.k_id = knd.k_id
              WHERE k.k_email = @email AND k.k_lozinka = @password", conn);
        cmd.Parameters.AddWithValue("email", NpgsqlDbType.Varchar, email);
        cmd.Parameters.AddWithValue("password", NpgsqlDbType.Varchar, password);

        try
        {
            using var reader = cmd.ExecuteReader();
            if (reader.Read())
            {
                var session = new UserSession
                {
                    UserId = reader.GetInt64(0),
                    IsAdmin = reader.GetBoolean(1),
                    Role = reader.GetString(2)
                };
                if (session.IsAdmin)
                    session.Role = "admin"; // Override role for admins
                return session;
            }
            else
            {
                Console.WriteLine("Invalid email or password.");
                return null;
            }
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Login error: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
            return null;
        }
    }

    // Display role-based menu
    static void DisplayMenu(UserSession session)
    {
        Console.WriteLine($"\nMenu (Logged in as {session.Role}{(session.IsAdmin ? " (Admin)" : "")}):");
        if (session.Role == "patnik" || session.IsAdmin)
        {
            Console.WriteLine("1. Buy Ticket");
            Console.WriteLine("2. Start Ride");
        }
        if (session.Role == "vozac" || session.IsAdmin)
        {
            Console.WriteLine("3. Start Bus Route");
        }
        if (session.Role == "konduktor" || session.IsAdmin)
        {
            Console.WriteLine("4. Do Control");
            Console.WriteLine("5. Write Fine");
        }
        if (session.IsAdmin)
        {
            Console.WriteLine("6. Register Passenger");
            Console.WriteLine("7. Register Driver");
            Console.WriteLine("8. Register Conductor");
            Console.WriteLine("9. Show Analytics View");
        }
        Console.WriteLine("10. Login as another user");
        Console.WriteLine("0. Exit");
    }

    // Helper to list rows then prompt for numeric ID
    static long PromptWithList(NpgsqlConnection conn, string sql, string idField, string displayField, string prompt)
    {
        using (var cmd = new NpgsqlCommand(sql, conn))
        using (var reader = cmd.ExecuteReader())
        {
            while (reader.Read())
                Console.WriteLine($"{reader[idField]} - {reader[displayField]}");
        }
        Console.Write(prompt);
        return long.Parse(Console.ReadLine());
    }

    // Helper to list rows then prompt for string ID
    static string PromptWithListString(NpgsqlConnection conn, string sql, string idField, string displayField, string prompt)
    {
        using (var cmd = new NpgsqlCommand(sql, conn))
        using (var reader = cmd.ExecuteReader())
        {
            while (reader.Read())
                Console.WriteLine($"{reader[idField]} - {reader[displayField]}");
        }
        Console.Write(prompt);
        return Console.ReadLine();
    }

    // ---------------- Passenger Registration ----------------
    static void RegisterPassenger(NpgsqlConnection conn)
    {
        Console.Write("Ime: "); var ime = Console.ReadLine();
        Console.Write("Adresa: "); var adresa = Console.ReadLine();
        Console.Write("Telefon: "); var tel = Console.ReadLine();
        Console.Write("Email: "); var email = Console.ReadLine();
        Console.Write("EMBG (13 digits): "); var embg = Console.ReadLine();
        Console.Write("Lozinka: "); var pass = Console.ReadLine();

        using var cmd = new NpgsqlCommand(
            "CALL registracija_korisnik(@ime, @adr, @tel, @em, @embg, @pass, @isAdmin, @uloga, @plata, @datum, @datumPrekin)", conn);
        cmd.Parameters.AddWithValue("ime", NpgsqlDbType.Varchar, ime);
        cmd.Parameters.AddWithValue("adr", NpgsqlDbType.Varchar, adresa);
        cmd.Parameters.AddWithValue("tel", NpgsqlDbType.Varchar, tel);
        cmd.Parameters.AddWithValue("em", NpgsqlDbType.Varchar, email);
        cmd.Parameters.AddWithValue("embg", NpgsqlDbType.Char, embg);
        cmd.Parameters.AddWithValue("pass", NpgsqlDbType.Varchar, pass);
        cmd.Parameters.AddWithValue("isAdmin", NpgsqlDbType.Boolean, false);
        cmd.Parameters.AddWithValue("uloga", NpgsqlDbType.Varchar, "patnik");
        cmd.Parameters.AddWithValue("plata", NpgsqlDbType.Numeric, DBNull.Value);
        cmd.Parameters.AddWithValue("datum", NpgsqlDbType.Date, DBNull.Value);
        cmd.Parameters.AddWithValue("datumPrekin", NpgsqlDbType.Date, DBNull.Value);

        try
        {
            cmd.ExecuteNonQuery();
            Console.WriteLine("Passenger registered successfully.");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error registering passenger: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Worker Registration (Driver/Conductor) ----------------
    static void RegisterWorker(NpgsqlConnection conn, string role)
    {
        Console.Write("Ime: "); var ime = Console.ReadLine();
        Console.Write("Adresa: "); var adresa = Console.ReadLine();
        Console.Write("Telefon: "); var tel = Console.ReadLine();
        Console.Write("Email: "); var email = Console.ReadLine();
        Console.Write("EMBG (13 digits): "); var embg = Console.ReadLine();
        Console.Write("Lozinka: "); var pass = Console.ReadLine();
        Console.Write("Plata: "); var plata = decimal.Parse(Console.ReadLine());
        Console.Write("Datum vrabotuvanje (yyyy-mm-dd): "); var datum = DateTime.Parse(Console.ReadLine());

        using var cmd = new NpgsqlCommand(
            "CALL registracija_korisnik(@ime, @adr, @tel, @em, @embg, @pass, @isAdmin, @uloga, @plata, @datum, @datumPrekin)", conn);
        cmd.Parameters.AddWithValue("ime", NpgsqlDbType.Varchar, ime);
        cmd.Parameters.AddWithValue("adr", NpgsqlDbType.Varchar, adresa);
        cmd.Parameters.AddWithValue("tel", NpgsqlDbType.Varchar, tel);
        cmd.Parameters.AddWithValue("em", NpgsqlDbType.Varchar, email);
        cmd.Parameters.AddWithValue("embg", NpgsqlDbType.Char, embg);
        cmd.Parameters.AddWithValue("pass", NpgsqlDbType.Varchar, pass);
        cmd.Parameters.AddWithValue("isAdmin", NpgsqlDbType.Boolean, false);
        cmd.Parameters.AddWithValue("uloga", NpgsqlDbType.Varchar, role);
        cmd.Parameters.AddWithValue("plata", NpgsqlDbType.Numeric, plata);
        cmd.Parameters.AddWithValue("datum", NpgsqlDbType.Date, datum.Date);
        cmd.Parameters.AddWithValue("datumPrekin", NpgsqlDbType.Date, DBNull.Value);

        try
        {
            cmd.ExecuteNonQuery();
            Console.WriteLine($"Registered {role} successfully.");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error registering {role}: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Ticket ----------------
    static void BuyTicket(NpgsqlConnection conn)
    {
        var tbId = PromptWithList(conn, "SELECT tb_id,tb_ime FROM TipBilet", "tb_id", "tb_ime", "Choose ticket type ID: ");
        var patnikId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Patnik USING(k_id)", "k_id", "k_ime", "Choose passenger k_id: ");

        var sql = @"INSERT INTO Bilet(b_datum_na_kupuvnje,patnik_k_id,tb_id,b_status)
                    VALUES(now(),@p,@t,'inactive') RETURNING b_id";
        using var cmd = new NpgsqlCommand(sql, conn);
        cmd.Parameters.AddWithValue("p", NpgsqlDbType.Bigint, patnikId);
        cmd.Parameters.AddWithValue("t", NpgsqlDbType.Integer, tbId);
        try
        {
            var bid = cmd.ExecuteScalar();
            Console.WriteLine($"Created ticket b_id: {bid}");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error buying ticket: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Ride ----------------
    static void StartRide(NpgsqlConnection conn)
    {
        var inlId = PromptWithList(conn, "SELECT inl_id,li_id FROM InstancaNaLinija WHERE inl_datum_end IS NULL", "inl_id", "li_id", "Choose InstancaNaLinija ID: ");
        var patnikId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Patnik USING(k_id)", "k_id", "k_ime", "Choose passenger k_id: ");
        var pnlId = PromptWithList(conn, "SELECT pnl_id,p_ime FROM PostojkaNaLinija JOIN Postojka USING(p_id)", "pnl_id", "p_ime", "Choose stop pnl_id: ");
        var bId = PromptWithList(conn, "SELECT b_id,b_status FROM Bilet WHERE patnik_k_id=" + patnikId, "b_id", "b_status", "Choose active ticket b_id: ");

        var sql = @"INSERT INTO Vozenje(vozenje_start,patnik_k_id,pnl_id,inl_id,vozenje_status,b_id)
                    VALUES(now(),@p,@pnl,@inl,'active',@b) RETURNING vozenje_id";
        using var cmd = new NpgsqlCommand(sql, conn);
        cmd.Parameters.AddWithValue("p", NpgsqlDbType.Bigint, patnikId);
        cmd.Parameters.AddWithValue("pnl", NpgsqlDbType.Integer, pnlId);
        cmd.Parameters.AddWithValue("inl", NpgsqlDbType.Integer, inlId);
        cmd.Parameters.AddWithValue("b", NpgsqlDbType.Bigint, bId);
        try
        {
            var vid = cmd.ExecuteScalar();
            Console.WriteLine($"Started ride vozenje_id: {vid}");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error starting ride: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Control ----------------
    static void DoControl(NpgsqlConnection conn)
    {
        var konduktorId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Konduktor USING(k_id)", "k_id", "k_ime", "Choose konduktor k_id: ");
        var inlId = PromptWithList(conn, "SELECT inl_id,li_id FROM InstancaNaLinija WHERE inl_datum_end IS NULL", "inl_id", "li_id", "Choose InstancaNaLinija ID: ");

        var sql = @"INSERT INTO Kontroli(kontrola_datum,konduktor_k_id,inl_id)
                    VALUES(now(),@k,@inl) RETURNING kontrola_id";
        using var cmd = new NpgsqlCommand(sql, conn);
        cmd.Parameters.AddWithValue("k", NpgsqlDbType.Bigint, konduktorId);
        cmd.Parameters.AddWithValue("inl", NpgsqlDbType.Integer, inlId);
        try
        {
            var kid = cmd.ExecuteScalar();
            Console.WriteLine($"Control recorded kontrola_id: {kid}");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error recording control: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Fine ----------------
    static void WriteFine(NpgsqlConnection conn)
{
    var konduktorId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Konduktor USING(k_id)", "k_id", "k_ime", "Choose konduktor k_id: ");
    var kontrolaId = PromptWithList(conn, "SELECT kontrola_id,kontrola_datum FROM Kontroli", "kontrola_id", "kontrola_datum", "Choose kontrola_id: ");
    Console.Write("Iznos: "); var iznos = decimal.Parse(Console.ReadLine());
    Console.Write("Dokument: "); var dok = Console.ReadLine();

    Console.Write("Is the passenger registered? (y/n): ");
    var reg = Console.ReadLine();
    if (reg?.ToLower() == "y")
    {
        var patnikId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Patnik USING(k_id)", "k_id", "k_ime", "Choose passenger k_id: ");
        using var cmd2 = new NpgsqlCommand(
            "CALL zapisi_kazna(@iznos, @plateno, CURRENT_DATE, @dok, @kon, @kont, 'registriran', null, @p, null, null, null)", conn);
        cmd2.Parameters.AddWithValue("iznos", NpgsqlDbType.Numeric, iznos);
        cmd2.Parameters.AddWithValue("plateno", NpgsqlDbType.Boolean, true);
        cmd2.Parameters.AddWithValue("dok", NpgsqlDbType.Varchar, dok);
        cmd2.Parameters.AddWithValue("kon", NpgsqlDbType.Bigint, konduktorId);
        cmd2.Parameters.AddWithValue("kont", NpgsqlDbType.Integer, kontrolaId);
        cmd2.Parameters.AddWithValue("p", NpgsqlDbType.Bigint, patnikId);
        try
        {
            cmd2.ExecuteNonQuery();
            Console.WriteLine("Fine recorded successfully for registered passenger.");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error recording fine: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }
    else
    {
        Console.Write("Ime: "); var ime = Console.ReadLine();
        Console.Write("Adresa: "); var adr = Console.ReadLine();
        Console.Write("Telefon: "); var tel = Console.ReadLine();
        using var cmd2 = new NpgsqlCommand(
            "CALL zapisi_kazna(@iznos, @plateno, CURRENT_DATE, @dok, @kon, @kont, 'neregistriran', null, null, @tel, @ime, @adr)", conn);
        cmd2.Parameters.AddWithValue("iznos", NpgsqlDbType.Numeric, iznos);
        cmd2.Parameters.AddWithValue("plateno", NpgsqlDbType.Boolean, true);
        cmd2.Parameters.AddWithValue("dok", NpgsqlDbType.Varchar, dok);
        cmd2.Parameters.AddWithValue("kon", NpgsqlDbType.Bigint, konduktorId);
        cmd2.Parameters.AddWithValue("kont", NpgsqlDbType.Integer, kontrolaId);
        cmd2.Parameters.AddWithValue("tel", NpgsqlDbType.Varchar, tel);
        cmd2.Parameters.AddWithValue("ime", NpgsqlDbType.Varchar, ime);
        cmd2.Parameters.AddWithValue("adr", NpgsqlDbType.Varchar, adr);
        try
        {
            cmd2.ExecuteNonQuery();
            Console.WriteLine("Fine recorded successfully for unregistered passenger.");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error recording fine: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }
}

    // ---------------- Bus Route ----------------
    static void StartBusRoute(NpgsqlConnection conn)
    {
        var linijaId = PromptWithList(conn, "SELECT li_id,li_ime FROM Linija", "li_id", "li_ime", "Choose Linija ID: ");
        var avtobusReg = PromptWithListString(conn, "SELECT a_registracija,a_seriski_broj FROM Avtobus", "a_registracija", "a_seriski_broj", "Choose Avtobus a_registracija: ");
        var vozacId = PromptWithList(conn, "SELECT k_id,k_ime FROM Korisnik JOIN Vozac USING(k_id)", "k_id", "k_ime", "Choose Vozac k_id: ");

        var sql = @"INSERT INTO InstancaNaLinija(inl_datum_start,vozac_k_id,a_registracija,li_id)
                    VALUES(now(),@v,@a,@l) RETURNING inl_id";
        using var cmd = new NpgsqlCommand(sql, conn);
        cmd.Parameters.AddWithValue("v", NpgsqlDbType.Bigint, vozacId);
        cmd.Parameters.AddWithValue("a", NpgsqlDbType.Varchar, avtobusReg);
        cmd.Parameters.AddWithValue("l", NpgsqlDbType.Integer, linijaId);
        try
        {
            var inlid = cmd.ExecuteScalar();
            Console.WriteLine($"Started InstancaNaLinija inl_id: {inlid}");
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error starting bus route: {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }

    // ---------------- Analytics ----------------
    static void ShowView(NpgsqlConnection conn)
    {
        var views = new List<string>();
        using (var cmd = new NpgsqlCommand("SELECT matviewname FROM pg_matviews WHERE schemaname = 'project_v3' ORDER BY matviewname", conn))
        using (var reader = cmd.ExecuteReader())
        {
            while (reader.Read())
                views.Add(reader.GetString(0));
        }

        if (views.Count == 0)
        {
            Console.WriteLine("No materialized views found in the project_v3 schema.");
            return;
        }

        Console.WriteLine("Available materialized views:");
        for (int i = 0; i < views.Count; i++)
            Console.WriteLine($"{i + 1}. {views[i]}");

        Console.Write("Choose a view by number: ");
        if (!int.TryParse(Console.ReadLine(), out int choice) || choice < 1 || choice > views.Count)
        {
            Console.WriteLine("Invalid choice.");
            return;
        }

        var viewName = views[choice - 1];

        try
        {
            using var cmdView = new NpgsqlCommand($"SELECT * FROM {viewName}", conn);
            using var reader = cmdView.ExecuteReader();
            var cols = reader.GetColumnSchema();

            Console.WriteLine($"\nContents of '{viewName}':");
            while (reader.Read())
            {
                for (int i = 0; i < cols.Count; i++)
                    Console.Write($"{cols[i].ColumnName}: {reader.GetValue(i)} ");
                Console.WriteLine();
            }
        }
        catch (PostgresException ex)
        {
            Console.WriteLine($"Error showing view '{viewName}': {ex.Message}, SQLState: {ex.SqlState}, Detail: {ex.Detail}");
        }
    }
}