package it.finki.charitable.controller;

import it.finki.charitable.entities.AppUser;
import it.finki.charitable.entities.DonationPost;
import it.finki.charitable.services.DonationPostService;
import it.finki.charitable.services.EmailService;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

import java.io.File;
import java.util.List;

@Controller
public class ModeratorController {

    private final DonationPostService donationPostService;
    private final EmailService emailService;

    public ModeratorController(DonationPostService donationPostService, EmailService emailService) {
        this.donationPostService = donationPostService;
        this.emailService = emailService;
    }

    @RequestMapping("moderator/approval")
    public String approval(Model model) {
        List<DonationPost> postList = donationPostService.findAllByApproved(false);
        if (postList.size() == 0) {
            model.addAttribute("noPosts", true);
            return "postApproval";
        }
        model.addAttribute("postList", postList);
        return "postApproval";
    }

    @RequestMapping("moderator/post")
    public String post(Model model, @RequestParam Long postid) {
        DonationPost post = donationPostService.getById(postid);
        if (post == null) {
            model.addAttribute("notFound", true);
            return "post";
        }
        AppUser user = post.getUser();
        model.addAttribute("post", post);
        model.addAttribute("createdByFirstName", user.getFirstName());
        model.addAttribute("createdByLastName", user.getLastName());
        return "moderatorPost";
    }

    @RequestMapping("/moderator/approvePost")
    public String approvePost(@RequestParam Long postid) {
        DonationPost post = donationPostService.getById(postid);
        post.setApproved(true);
        donationPostService.save(post);
        emailService.sendApprovalEmail(post.getUser().getEmail(),"CharitAbleMk: " + post.getTitle() + " has been approved", postid);
        return "redirect:/moderator/approval";
    }

    @RequestMapping("/moderator/dontApprove")
    public String dontApprove(@RequestParam Long postid,
                              @RequestParam String description) {
        DonationPost post = donationPostService.getById(postid);
        emailService.sendNoApprovalEmail(post.getUser().getEmail(), "CharitAbleMk: " + post.getTitle() + " has not been approved", description);
        List<String> fileForDeletion = post.getPhotosForDeletion();
        for (String f : fileForDeletion) {
            File file = new File(f);
            file.delete();
        }
        donationPostService.delete(post);
        return "redirect:/moderator/approval";
    }

    @ModelAttribute("user")
    public AppUser addAttributes() {
        if (SecurityContextHolder.getContext().getAuthentication().getPrincipal() != "anonymousUser") {
            return (AppUser) SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        }
        return null;
    }
}
