package it.finki.charitable.services;

import it.finki.charitable.entities.DonationPost;
import it.finki.charitable.entities.Reason;
import it.finki.charitable.entities.ReportPost;
import it.finki.charitable.repository.ReportPostRepository;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class ReportPostService {

    private final ReportPostRepository reportPostRepository;

    public ReportPostService(ReportPostRepository reportPostRepository) {
        this.reportPostRepository = reportPostRepository;
    }

    public List<ReportPost> findAll() {
        return reportPostRepository.findAll();
    }

    public ReportPost findById(Long id) {
        return reportPostRepository.getById(id);
    }

    public ReportPost findByDonationPost(DonationPost post) {
        return reportPostRepository.findByDonationPost(post);
    }

    public void save(ReportPost post) {
        reportPostRepository.save(post);
    }

    public void delete(ReportPost reportPost) {
        reportPostRepository.delete(reportPost);
    }
}
