
create table restorani(
	restoran_id integer primary key,
	restoran_ime varchar(50) not null,
	restoran_rejting integer not null,
	restoran_adresa varchar(50) not null
);

create table restorani_tel_broevi(
	restoran_id integer references restorani(restoran_id),
	broj varchar(50),
	constraint pk_restorani_tel_broevi primary key (restoran_id,broj)
);

create table meni(
	meni_id integer primary key
);

create table tip(
	tip_id integer primary key,
	tip_ime varchar(50) not null
);

create table obroci(
	obrok_id integer primary key,
	obrok_opis varchar(10000) not null,
	obrok_ime varchar(50) not null
);

create table naracki(
	naracka_id integer primary key,
	naracana_na timestamp not null, 
	naracka_status varchar(50) not null,
	naracka_cena_vkupna integer not null
);

create table rezervacii(
	rezervacija_id integer primary key,
	rezervacija_vreme timestamp not null,
	br_lugje integer not null,
	rezervacija_status varchar(50) not null,
	rezervacija_opis varchar(10000) not null
);

create table korisnici(
	user_id integer primary key,
	user_ime varchar(50) not null,
	user_prezime varchar(50) not null,
	user_lozinka varchar(300) not null
);

create table kupuvaci(
	user_id integer primary key,
	kupuvac_tel_broj varchar(50) not null,
	constraint fk_user foreign key (user_id) references korisnici (user_id)
	on delete cascade on update cascade
);

create table dostavuvaci(
	user_id integer primary key,
	dostavuvac_vraboten_od date not null,
	constraint fk_user foreign key (user_id) references korisnici (user_id)
	on delete cascade on update cascade
);

create table sistemski_admin(
	user_id integer primary key,
	constraint fk_user foreign key (user_id) references korisnici (user_id)
	on delete cascade on update cascade
);

create table menadzeri(
	user_id integer primary key,
	menadzer_vraboten_od date not null,
	constraint fk_user foreign key (user_id) references korisnici (user_id)
	on delete cascade on update cascade
);

create table cena(
	obrok_id integer references obroci(obrok_id),
	cena_id integer,
	cena_iznos integer not null,
	cena_vazi_od date not null,
	cena_vazi_do date not null,
	constraint pk_cena primary key (obrok_id,cena_id)
);

create table restoran_ima_rezervacija_za(
	restoran_id integer references restorani(restoran_id),
	rezervacija_id integer references rezervacii(rezervacija_id),
	constraint pk_restoran_ima_rezervacija_za primary key(restoran_id)
);

create table meni_pripagja_na_tip(
	meni_id integer references meni(meni_id),
	tip_id integer references tip(tip_id),
	constraint pk_meni_pripagja_na_tip primary key(meni_id)
);

create table restoran_e_upravuvan_od(
	restoran_id integer references restorani(restoran_id),
	user_id integer references korisnici(user_id),
	constraint pk_restoran_e_upravuvan_od primary key(restoran_id)
); 

create table meni_e_ponudeno_vo_restoran(
	meni_id integer references meni(meni_id),
	restoran_id integer references restorani(restoran_id),
	constraint pk_meni_e_ponudeno_vo_restoran primary key(meni_id)
);

create table obrok_se_sodrzi_vo_meni(
	obrok_id integer references obroci(obrok_id),
	meni_id integer references meni(meni_id),
	constraint pk_obrok_se_sodrzi_vo_meni primary key(obrok_id)
);

create table rezervacija_e_napravena_za_korisnik(
	rezervacija_id integer references rezervacii(rezervacija_id),
	user_id integer references korisnici(user_id),
	constraint pk_rezervacija_e_napravena_za_korsinik primary key(rezervacija_id)
);

create table naracka_e_kreirana_od_korisnik(
	naracka_id integer references naracki(naracka_id),
	user_id integer references korisnici(user_id),
	constraint pk_naracka_e_kreirana_od_korisnik primary key(naracka_id)
);

create table naracka_e_dostavena_od_dostavuvac(
	naracka_id integer references naracki(naracka_id),
	user_id integer references korisnici(user_id),
	constraint pk_naracka_e_dostavena_od_dostavuvac primary key (naracka_id)
);

create table rezervacija_rezervira_obrok(
	obrok_id integer references obroci(obrok_id),
	rezervacija_id integer references rezervacii(rezervacija_id),
	constraint pk_rezervacija_rezervira_obrok primary key(obrok_id,rezervacija_id)
);

create table naracka_se_sostoi_od_obrok(
	naracka_id integer references naracki(naracka_id),
	obrok_id integer references obroci(obrok_id),
	kolicina integer not null,
	cena integer not null,
	constraint pk_naracka_se_sostoi_od_obrok primary key (naracka_id,obrok_id)
);

-- brisenje tabeli
drop table cena ;
drop table dostavuvaci ;
drop table korisnici ;
drop table kupuvaci ;
drop table menadzeri ;
drop table meni ;
drop table meni_e_ponudeno_vo_restoran ;
drop table meni_pripagja_na_tip ;
drop table naracka_e_dostavena_od_dostavuvac ;
drop table naracka_e_kreirana_od_korisnik ;
drop table naracka_se_sostoi_od_obrok ;
drop table naracki ;
drop table obroci ;
drop table obrok_se_sodrzi_vo_meni ;
drop table restoran_e_upravuvan_od ;
drop table restoran_ima_rezervacija_za ;
drop table restorani ;
drop table restorani_tel_broevi ;
drop table rezervacii ;
drop table rezervacija_e_napravena_za_korisnik ;
drop table rezervacija_rezervira_obrok ;
drop table sistemski_admin ;
drop table tip ;
