--lokacii (adresa)
create table lokacii(
adresa varchar primary key
);

--korisnici (korisnik_id, datum_kreiran, lozinka)
create table korisnici(
korisnik_id serial primary key,
datum_kreiran date not null,
lozinka varchar not null
);

--keterinzi (korisnik_id*(korisnici), ime, cena, adresa, tel_broj)
create table keterinzi(
korisnik_id integer primary key,
ime varchar not null,
cena integer not null,
adresa varchar not null,
tel_broj varchar not null,
constraint fk_keterinzi_korisnici foreign key (korisnik_id) references korisnici (korisnik_id)
);

--klienti (korisnik_id_korisnici*(korisnici), br_organizirani_nastani, tel_broj, korisnik_id_keterinzi*(keterinzi))
create table klienti(
korisnik_id_korisnici integer primary key,
br_organizirani_nastani integer not null,
tel_broj varchar not null,
korisnik_id_keterinzi integer not null,
constraint fk_klienti_korisnici foreign key (korisnik_id_korisnici) references korisnici (korisnik_id),
constraint fk_klienti_keterinzi foreign key (korisnik_id_keterinzi) references keterinzi (korisnik_id)
);

--admini (korisnik_id*(korisnici), br_organizirani_nastani)
create table admini(
korisnik_id integer primary key,
br_organizirani_nastani integer not null,
constraint fk_admini_korisnici foreign key (korisnik_id) references korisnici (korisnik_id)
);

--nastani (nastan_id, status, vreme, tip, opis, adresa*(lokacii), korisnik_id_admini*(admini), korisnik_id_klienti*(klienti))
create table nastani(
nastan_id serial primary key,
status varchar not null,
vreme varchar not null,
tip varchar not null,
opis varchar,
adresa varchar not null, 
korisnik_id_admini integer,
korisnik_id_klienti integer not null,
constraint fk_nastani_lokacii foreign key (adresa) references lokacii (adresa),
constraint fk_nastani_admini foreign key (korisnik_id_admini) references admini (korisnik_id),
constraint fk_nastani_klienti foreign key (korisnik_id_klienti) references klienti (korisnik_id)
);

--bendovi (korisnik_id*(korisnici), ime, cena, tel_broj)
create table bendovi(
korisnik_id integer primary key,
ime varchar not null,
cena integer not null,
tel_broj varchar not null,
constraint fk_bendovi_korisnici foreign key (korisnik_id) references korisnici (korisnik_id)
);

--fotografi (korisnik_id*(korisnici), cena, tel_broj, portfolio)
create table fotografi(
korisnik_id integer primary key,
cena integer not null,
tel_broj varchar not null,
portfolio varchar not null,
constraint fk_fotografi_korisnici foreign key (korisnik_id) references korisnici (korisnik_id)
);

--kelneri (korisnik_id_korisnici*(korisnici), slobodni_denovi, god_iskustvo, korisnik_id_keterinzi*(keterinzi))
create table kelneri( 
korisnik_id_korisnici integer primary key,
slobodni_denovi integer not null, 
god_iskustvo integer not null, 
korisnik_id_keterinzi integer not null,
constraint fk_kelneri_korisnici foreign key (korisnik_id_korisnici) references korisnici (korisnik_id),
constraint fk_kelneri_keterinzi foreign key (korisnik_id_keterinzi) references keterinzi (korisnik_id)
);

--produkti (produkt_id, ime)
create table produkti(
produkt_id serial primary key,
ime varchar not null  
); 

--hrana (produkt_id*(produkti), vegetarijansko, kalorii, vegan)
create table hrana(
produkt_id integer primary key,
vegetarijansko boolean not null,
kalorii integer,
vegan boolean not null,
constraint fk_hrana_produkti foreign key (produkt_id) references produkti (produkt_id)
);

--pijaloci (produkt_id*(produkti), dali_alkoholen, procenti_alkohol)
create table pijaloci(
produkt_id integer primary key,
dali_alkoholen boolean not null,
procenti_alkohol integer,
constraint fk_pijaloci_produkti foreign key (produkt_id) references produkti (produkt_id)
);

--tel_broj (adresa*(lokacii), tel_broj)
create table tel_broj( 
adresa varchar not null, 
tel_broj varchar,
constraint pk_tel_broj primary key (adresa, tel_broj),
constraint fk_tel_broj_lokacii foreign key (adresa) references lokacii (adresa)
);

--alergeni (produkt_id*(hrana), alergeni)
create table alergeni(
produkt_id integer not null,
alergeni varchar,
constraint pk_alergeni primary key (produkt_id, alergeni),
constraint fk_alergeni_hrana foreign key (produkt_id) references hrana (produkt_id)
);


--bend_sviri_nastan  (korisnik_id*(bendovi), nastan_id*(nastani), status)
create table bend_sviri_nastan (
korisnik_id integer,
nastan_id integer, 
status varchar,
constraint pk_sviri primary key (korisnik_id, nastan_id),
constraint fk_sviri_bendovi foreign key (korisnik_id) references bendovi (korisnik_id),
constraint fk_sviri_nastani foreign key (nastan_id) references nastani (nastan_id)
);

--ketering_nudi_produkt  (korisnik_id*(keterinzi), produkt_id*(produkti))
create table ketering_nudi_produkt (
korisnik_id integer,
produkt_id integer,
constraint pk_nudi primary key (korisnik_id, produkt_id),
constraint fk_nudi_keterinzi foreign key (korisnik_id) references keterinzi (korisnik_id),
constraint fk_nudi_produkti foreign key (produkt_id) references produkti (produkt_id)
);

--ketering_rezervira_nastan  (korisnik_id*(keterinzi), nastan_id*(nastani), status, kolicina)
create table ketering_rezervira_nastan (
korisnik_id integer,
nastan_id integer, 
status varchar,
kolicina integer, 
constraint pk_rezervira primary key (korisnik_id, nastan_id),
constraint fk_rezervira_keterinzi foreign key (korisnik_id) references keterinzi (korisnik_id),
constraint fk_rezervira_nastani foreign key (nastan_id) references nastani (nastan_id)
);

--fotograf_slika_nastan  (korisnik_id*(fotografi), nastan_id*(nastani), status)
create table fotograf_slika_nastan (
korisnik_id integer, 
nastan_id integer,
status varchar, 
constraint pk_slika primary key (korisnik_id, nastan_id),
constraint fk_slika_fotografi foreign key (korisnik_id) references fotografi (korisnik_id),
constraint fk_slika_nastani foreign key (nastan_id) references nastani (nastan_id)
);

--kelner_raboti_na_nastan  (korisnik_id*(kelneri), nastan_id*(nastani), status)
create table kelner_raboti_na_nastan (
korisnik_id integer,
nastan_id integer,
constraint pk_raboti_na primary key (korisnik_id, nastan_id),
constraint fk_raboti_na_kelneri foreign key (korisnik_id) references kelneri (korisnik_id_korisnici),
constraint fk_raboti_na_nastani foreign key (nastan_id) references nastani (nastan_id)
);

alter table kelner_raboti_na_nastan 
add column status varchar

--drop table lokacii
--drop table nastani
--drop table korisnici
--drop table admini
--drop table klienti
--drop table bendovi
--drop table fotografi
--drop table kelneri
--drop table keterinzi
--drop table produkti
--drop table hrana
--drop table pijaloci
--drop table tel_broj
--drop table alergeni
--drop table sviri
--drop table nudi
--drop table rezervira
--drop table slika
--drop table raboti_na
