﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class StudentRepo : Repository<Student>, IStudentRepo
    {
        public StudentRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<Student> GetStudent(long applicationUserFk)
        {
            return await DbSet.FirstOrDefaultAsync(x => x.ApplicationUserFk == applicationUserFk);
        }

        public async Task<StudentSelfDto> GetStudentSelfDto(long applicationUserFk)
        {
            return await DbSet
                .AsNoTracking()
                .Include(x => x.Questions)
                .Include(x => x.StudentTeams).ThenInclude(x => x.Team)
                .Where(x => x.ApplicationUserFk == applicationUserFk)
                .Select(x => new StudentSelfDto(x.Uid,
                                                x.ApplicationUserFk,
                                                x.IndexNumber,
                                                x.Reputation,
                                                x.ImageUrl,
                                                x.Questions.Select(y => new StudentQuestionDto(y.Uid, y.Title)),
                                                x.StudentTeams.Select(y => new StudentTeamDto(y.Team.Uid, y.Team.Name))))
                .FirstOrDefaultAsync();
        }
    }
}
