import { Component, EventEmitter, Input, OnInit, Output } from '@angular/core';
import { VoteType } from 'src/app/shared-app/models';
import { ButtonType } from '../button/button.models';

@Component({
  selector: 'app-vote',
  templateUrl: './vote.component.html',
  styleUrls: ['./vote.component.scss']
})
export class VoteComponent implements OnInit {
  @Input() voteCount: number | undefined;
  @Input() canSetCorrectAnswer: boolean | null = false;
  @Input() correct = false;
  @Output() voteClicked = new EventEmitter<VoteType>();
  @Output() setCorrectAnswer = new EventEmitter<void>();

  VoteType = VoteType;
  ButtonType = ButtonType;

  constructor() {}

  ngOnInit(): void {}

  public voted(voteType: VoteType): void {
    this.voteClicked.emit(voteType);
  }
}
