﻿using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.UnitOfWork;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Api.ApplicationServices.Questioning.EventHandlers
{
    public class RemoveOtherCorrectAnswersAppartFromTheNewOneAndUpdateStudentReputationsEventHandler : IEventHandler<AnswerMarkedAsCorrectEvent>
    {
        public RemoveOtherCorrectAnswersAppartFromTheNewOneAndUpdateStudentReputationsEventHandler(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task Handle(AnswerMarkedAsCorrectEvent notification, CancellationToken cancellationToken)
        {
            var questionWithAnswers = await UnitOfWork.Questions.GetQuestionWithAnswersAndStudents(notification.QuestionUid);

            if (questionWithAnswers == null)
            {
                return;
            }

            foreach (var answer in questionWithAnswers.Answers)
            {
                if (answer.CorrectAnswer && answer.Uid != notification.AnswerUid)
                {
                    answer.CorrectAnswer = false;
                    answer.Student.Reputation = answer.Student.Reputation - 5;
                }
                if (answer.Uid == notification.AnswerUid)
                {
                    answer.Student.Reputation = answer.Student.Reputation + 5;
                }
            }

            await UnitOfWork.SaveAsync();
        }
    }
}
