﻿using FinkiChattery.Api.ApplicationServices.User;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Queries.User;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/[controller]/")]
    [ApiController]
    public class SelfController : ControllerBase
    {
        public SelfController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpGet]
        [Authorize]
        public async Task<IActionResult> Getself()
        {
            var selfUserDto = await MediatorService.SendQueryAsync(new GetSelfUserQuery());
            return Ok(selfUserDto.ToSelfUserResponse());
        }
    }
}
