﻿using FinkiChattery.Commands.Questioning.Validators.Contracts;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class AnswerInQuestionWithUidExists : AsyncValidatorBase
    {
        public AnswerInQuestionWithUidExists(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var dto = (AnswerInQuestionWithUidExistsDto)context.PropertyValue;

            return await UnitOfWork.Answers.AnswerInQuestionExists(dto.QuestionUid, dto.AnswerUid);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.AnswerInQuestionNotFound;
        }
    }
}
