﻿using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class AnswerIsNotAlreadyMarkedAsCorrect : AsyncValidatorBase
    {
        public AnswerIsNotAlreadyMarkedAsCorrect(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var answerUid = (Guid)context.PropertyValue;

            var answer = await UnitOfWork.Answers.GetByUidAsync(answerUid);

            return !answer.CorrectAnswer;
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.AnswerIsAlreadyMarkedAsCorrect;
        }
    }
}
