﻿using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using FluentValidation.Validators;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning.Validators
{
    public class StudentIsOwnerOfQuestion : AsyncValidatorBase
    {
        public StudentIsOwnerOfQuestion(IUnitOfWork unitOfWork, ICurrentUser currentUser)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }

        protected override async Task<bool> IsValidAsync(PropertyValidatorContext context, CancellationToken cancellation)
        {
            var questionUid = (Guid)context.PropertyValue;

            return await UnitOfWork.Questions.QuestionIsOwnedByStudent(questionUid, CurrentUser.Id);
        }

        protected override string GetDefaultMessageTemplate()
        {
            return QuestioningErrorCodes.StudentDoesNotOwnQuestion;
        }
    }
}
