﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using Microsoft.EntityFrameworkCore;
using System;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class AnswerRepo : Repository<Answer>, IAnswerRepo
    {
        public AnswerRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<bool> AnswerInQuestionExists(Guid questionUid, Guid answerUid)
        {
            return await DbSet
                .AsNoTracking()
                .Where(x => x.Question.Uid == questionUid && x.Uid == answerUid)
                .AnyAsync();
        }
    }
}
