﻿using FinkiChattery.Persistence.Context;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.Repositories.Contracts;
using Microsoft.EntityFrameworkCore;
using System.Linq;
using System.Threading.Tasks;

namespace FinkiChattery.Persistence.Repositories
{
    public class ModeratorRepo : Repository<Moderator>, IModeratorRepo
    {
        public ModeratorRepo(ApplicationDbContext dbContext) : base(dbContext)
        {
        }

        public async Task<ModeratorSelfDto> GetModeratorSelfDto(long applicationUserId)
        {
            return await DbSet
                .AsNoTracking()
                .Where(x => x.ApplicationUserFk == applicationUserId)
                .Select(x => new ModeratorSelfDto(x.Uid, x.ApplicationUserFk))
                .FirstOrDefaultAsync();
        }
    }
}
