import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';

import { ButtonType } from 'src/app/shared-app/components/generic/button/button.models';
import { CategoryViewModel } from 'src/app/shared-app/models';
import { AskQuestionRequest } from '../../models/questioning-request.models';
import { QuestioningApiService } from '../../services/questioning-api.service';

@Component({
  selector: 'app-ask-question',
  templateUrl: './ask-question.component.html',
  styleUrls: ['./ask-question.component.scss']
})
export class AskQuestionComponent implements OnInit {
  public titleForm = new FormControl('', [Validators.required, Validators.maxLength(500)]);
  public textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  public categoriesForm = new FormControl([]);

  public questionFormGroup: FormGroup;
  public ButtonType = ButtonType;

  // TODO: PULL FROM ENDPOINT
  public categoriesList: CategoryViewModel[] = [
    new CategoryViewModel('123', 'test'),
    new CategoryViewModel('345', 'test 2'),
    new CategoryViewModel('345', 'test 3'),
    new CategoryViewModel('345', 'test 4'),
    new CategoryViewModel('345', 'test 5')
  ];

  constructor(private api: QuestioningApiService) {
    this.questionFormGroup = new FormGroup({
      title: this.titleForm,
      text: this.textForm,
      categories: this.categoriesForm
    });
  }

  ngOnInit(): void {}

  public askQuestion(): void {
    const body = new AskQuestionRequest(this.titleForm.value, this.textForm.value, this.categoriesForm.value);
    this.api.askQuestion(body).subscribe(() => {});
  }
}
