import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';
import { AuthorizedStudentGuard } from 'src/app/core/guards/authorized-student.guard';
import { AskQuestionComponent } from './components/ask-question/ask-question.component';

const routes: Routes = [
  {
    path: 'ask',
    component: AskQuestionComponent,
    canActivate: [AuthorizedStudentGuard]
  }
];

@NgModule({
  imports: [RouterModule.forChild(routes)],
  exports: [RouterModule]
})
export class QuestioningRoutingModule {}
