import { HttpErrorResponse } from '@angular/common/http';
import { Injectable } from '@angular/core';
import { Action, Store } from '@ngrx/store';
import { Observable, throwError } from 'rxjs';
import { catchError, filter, map } from 'rxjs/operators';

import { CategoryStateViewModel } from 'src/app/shared-app/models';
import { EffectStartedWorking, GetCategoriesState } from './category-state/category.actions';
import { categoriesStateQuery } from './category-state/category.selectors';
import { CategoryState } from './category-state/category.state';

@Injectable({
  providedIn: 'root'
})
export class CategoryFacadeService {
  effectWorking$: Observable<boolean | HttpErrorResponse>;

  constructor(private store: Store<CategoryState>) {
    this.effectWorking$ = this.store.select(categoriesStateQuery.effectWorking).pipe(
      filter((effect) => effect !== null),
      map((effect) => {
        if (effect instanceof HttpErrorResponse) {
          throw effect;
        } else {
          return effect;
        }
      }),
      catchError((err) => {
        return throwError(err);
      })
    );
  }

  public getCategories(): Observable<CategoryStateViewModel[]> {
    return this.store.select(categoriesStateQuery.getCategories);
  }

  public fetchCategories(): void {
    this.dispatchEffect(new GetCategoriesState());
  }

  private dispatch(action: Action): void {
    this.store.dispatch(action);
  }

  private dispatchEffect(action: Action): void {
    this.dispatch(new EffectStartedWorking());
    this.dispatch(action);
  }
}
