﻿using FinkiChattery.Contracts.Questioning.GetCategories;
using FinkiChattery.Persistence.Models;
using System.Collections.Generic;
using System.Linq;

namespace FinkiChattery.Api.ApplicationServices.Questioning
{
    public static class CategoryMapper
    {
        public static List<CategoryDto> ToCategoryDtos(this IEnumerable<Category> categories)
        {
            var categoryDtos = new List<CategoryDto>();

            if (categories.Any())
            {
                categoryDtos = categories.Select(x => new CategoryDto(x.Uid, x.Name)).ToList();
            }

            return categoryDtos;
        }
    }
}
