﻿using FinkiChattery.Api.ApplicationServices.Questioning;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Queries.Questioning;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/[controller]")]
    [ApiController]
    public class CategoriesController : ControllerBase
    {
        public CategoriesController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpGet]
        [Authorize]
        public async Task<IActionResult> GetCategories()
        {
            var categoriesList = await MediatorService.SendQueryAsync(new GetCategoriesQuery());
            return Ok(categoriesList.ToCategoryDtos());
        }
    }
}
