﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Persistence.Models;
using FinkiChattery.Persistence.UnitOfWork;
using Microsoft.EntityFrameworkCore;
using System.Collections.Generic;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Queries.Questioning
{
    public class GetCategoriesQuery : IQuery<List<Category>>
    {
        public GetCategoriesQuery()
        {
        }
    }

    public class GetCategories : IQueryHandler<GetCategoriesQuery, List<Category>>
    {
        public GetCategories(IUnitOfWork unitOfWork)
        {
            UnitOfWork = unitOfWork;
        }

        public IUnitOfWork UnitOfWork { get; }

        public async Task<List<Category>> Handle(GetCategoriesQuery request, CancellationToken cancellationToken)
        {
            return await UnitOfWork.Categories.All().ToListAsync();
        }
    }
}
