import { Component, OnInit } from '@angular/core';
import { Router } from '@angular/router';

import { AskQuestionRequest } from 'src/app/shared-app/models';
import { QuestioningApiService } from '../../services/questioning-api.service';

@Component({
  selector: 'app-ask-question',
  templateUrl: './ask-question.component.html',
  styleUrls: ['./ask-question.component.scss']
})
export class AskQuestionComponent implements OnInit {
  constructor(private api: QuestioningApiService, private router: Router) {}

  ngOnInit(): void {}

  public askQuestionAsStudent(body: AskQuestionRequest): void {
    this.api.askQuestion(body).subscribe((questionUid) => {
      this.router.navigateByUrl(`questioning/${questionUid}`);
    });
  }
}
