import { AnswerQuestionStateViewModel, VoteType } from 'src/app/shared-app/models';
import { QuestionAction, QuestionActionTypes } from './question.actions';
import { initialState, QuestionState } from './question.state';

export function reducer(state = initialState, action: QuestionAction): QuestionState {
  switch (action.type) {
    case QuestionActionTypes.GetQuestionStateSuccess:
      return {
        ...state,
        question: action.payload
      };
    case QuestionActionTypes.GetPreviewQuestionsLatestSuccess:
      return {
        ...state,
        previewQuestionsLatest: action.payload
      };
    case QuestionActionTypes.GetPreviewQuestionsPopularSuccess:
      return {
        ...state,
        previewQuestionsPopular: action.payload
      };
    case QuestionActionTypes.GetSearchQuestionsSuccess:
      return {
        ...state,
        searchQuestions: action.payload,
        searchQuestionsQuery: action.query
      };
    case QuestionActionTypes.VoteAnswerSuccess: {
      if (state.question) {
        return {
          ...state,
          question: {
            ...state.question,
            answers: state.question.answers.map((x) => {
              if (x.uid === action.payload.answerUid) {
                let votesCountNew = x.votesCount;

                switch (action.payload.voteType) {
                  case VoteType.Upvote:
                    votesCountNew++;
                    break;
                  case VoteType.Downvote:
                    votesCountNew--;
                    break;
                }

                return {
                  ...x,
                  votesCount: votesCountNew
                };
              }

              return x;
            })
          }
        };
      }

      return {
        ...state
      };
    }
    case QuestionActionTypes.SetCorrectAnswerSuccess: {
      if (state.question) {
        return {
          ...state,
          question: {
            ...state.question,
            answers: state.question.answers.map((x) => {
              if (x.correctAnswer) {
                return {
                  ...x,
                  correctAnswer: false
                };
              }
              if (x.uid === action.payload) {
                return {
                  ...x,
                  correctAnswer: true
                };
              }
              return x;
            })
          }
        };
      }

      return {
        ...state
      };
    }
    case QuestionActionTypes.RespondToAnswerSuccess: {
      if (state.question) {
        return {
          ...state,
          question: {
            ...state.question,
            answers: state.question.answers.map((x) => {
              if (x.uid === action.answerUid) {
                return {
                  ...x,
                  answerResponses: [...x.answerResponses, action.payload]
                };
              }

              return x;
            })
          }
        };
      }

      return {
        ...state
      };
    }
    case QuestionActionTypes.AnswerQuestionSuccess: {
      if (state.question) {
        return {
          ...state,
          question: {
            ...state.question,
            answers: [...state.question.answers, action.payload]
          }
        };
      }

      return {
        ...state
      };
    }
    case QuestionActionTypes.EffectStartedWorking: {
      return {
        ...state,
        effectWorking: true
      };
    }

    case QuestionActionTypes.EffectFinishedWorking: {
      return {
        ...state,
        effectWorking: false
      };
    }

    case QuestionActionTypes.EffectFinishedWorkingError: {
      return {
        ...state,
        effectWorking: action.payload
      };
    }

    default: {
      return {
        ...state
      };
    }
  }
}
