import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { FormControl, FormGroup, Validators } from '@angular/forms';

import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-answer-question',
  templateUrl: './answer-question.component.html',
  styleUrls: ['./answer-question.component.scss']
})
export class AnswerQuestionComponent implements OnInit {
  ButtonType = ButtonType;
  questionUid?: string;
  textForm = new FormControl('', [Validators.required, Validators.maxLength(4000)]);
  formGroup: FormGroup;

  constructor(private questionFacade: QuestionFacadeService) {
    this.formGroup = new FormGroup({
      text: this.textForm
    });
  }

  ngOnInit(): void {
    this.questionFacade.getQuestion().subscribe((question) => {
      this.questionUid = question.uid;
    });

    this.questionFacade.effectWorking$.subscribe((effect) => {
      if (!(effect instanceof HttpErrorResponse) && effect === false) {
        this.formGroup.reset();
      }
    });
  }

  answerQuestion(): void {
    if (this.formGroup.valid && this.questionUid) {
      this.questionFacade.answerQuestion(this.questionUid, this.textForm.value);
    }
  }
}
