import * as moment from 'moment';
import {
  AnswerQuestionStateViewModel,
  AnswerResponseQuestionStateViewModel,
  AnswerResponseStudentQuestionStateViewModel,
  AnswerStudentQuestionStateViewModel,
  PreviewQuestionCategoryViewModel,
  PreviewQuestionViewModel,
  QuestionCategoryQuestionStateViewModel,
  QuestionStateViewModel,
  StudentQuestionStateViewModel,
  TeamQuestionStateViewModel
} from 'src/app/shared-app/models';
import { TranslateFromJsonService } from 'src/app/shared-app/services';
import { PreviewQuestionResponse, QuestionStateResponse } from './question-state.models';

export class QuestionMapper {
  public static ToQuestionStateViewModel(
    questionStateResponse: QuestionStateResponse,
    translate: TranslateFromJsonService
  ): QuestionStateViewModel {
    let answers: AnswerQuestionStateViewModel[] = [];

    if (questionStateResponse.answersResponse.length > 0) {
      answers = questionStateResponse.answersResponse.map((x) => {
        let answerResponses: AnswerResponseQuestionStateViewModel[] = [];

        if (x.answerResponsesResponse.length > 0) {
          answerResponses = x.answerResponsesResponse.map((y) => {
            const answerResponseStudent = new AnswerResponseStudentQuestionStateViewModel(
              y.studentResponse.uid,
              y.studentResponse.index,
              y.studentResponse.imageUrl,
              y.studentResponse.reputation
            );

            return new AnswerResponseQuestionStateViewModel(y.uid, y.text, moment(y.createdOn), answerResponseStudent);
          });
        }

        const answerStudent = new AnswerStudentQuestionStateViewModel(
          x.studentResponse.uid,
          x.studentResponse.index,
          x.studentResponse.imageUrl,
          x.studentResponse.reputation
        );

        return new AnswerQuestionStateViewModel(
          x.uid,
          x.text,
          x.correctAnswer,
          moment(x.createdOn),
          x.upvotesCount,
          answerStudent,
          answerResponses
        );
      });
    }

    let categories: QuestionCategoryQuestionStateViewModel[] = [];

    if (questionStateResponse.categoriesResponse.length > 0) {
      categories = questionStateResponse.categoriesResponse.map(
        (x) => new QuestionCategoryQuestionStateViewModel(x.uid, x.name, translate.instant(x.name))
      );
    }

    let team: TeamQuestionStateViewModel | null = null;

    if (questionStateResponse.teamResponse) {
      team = new TeamQuestionStateViewModel(questionStateResponse.teamResponse.uid, questionStateResponse.teamResponse.name);
    }

    const student = new StudentQuestionStateViewModel(
      questionStateResponse.studentResponse.uid,
      questionStateResponse.studentResponse.index,
      questionStateResponse.studentResponse.imageUrl,
      questionStateResponse.studentResponse.reputation
    );

    return new QuestionStateViewModel(
      questionStateResponse.uid,
      questionStateResponse.title,
      questionStateResponse.text,
      moment(questionStateResponse.createdOn),
      questionStateResponse.views,
      moment(questionStateResponse.lastActiveOn),
      student,
      answers,
      categories,
      team
    );
  }

  public static ToPreviwQuestionsViewModel(
    previewQuestionsResponse: PreviewQuestionResponse[],
    translate: TranslateFromJsonService
  ): PreviewQuestionViewModel[] {
    let questions = new Array<PreviewQuestionViewModel>();

    if (previewQuestionsResponse.length > 0) {
      questions = previewQuestionsResponse.map((x) => {
        let categories = new Array<PreviewQuestionCategoryViewModel>();

        if (x.categories.length > 0) {
          categories = x.categories.map((y) => new PreviewQuestionCategoryViewModel(y.uid, y.text, translate.instant(y.text)));
        }

        return new PreviewQuestionViewModel(x.uid, x.title, moment(x.createdOn), x.views, x.answersCount, categories);
      });
    }

    return questions;
  }
}
