import { HttpErrorResponse } from '@angular/common/http';
import { Component, OnInit } from '@angular/core';
import { NotificationService } from 'src/app/core/services/notification.service';
import { StudentQuestionService } from 'src/app/core/services/student-question.service';
import { QuestionFacadeService } from 'src/app/core/state/question-facade.service';

import { QuestionStateViewModel, VoteType } from 'src/app/shared-app/models';
import { SharedDialogService } from 'src/app/shared-app/services/shared-dialog.service';
import { ButtonType } from '../../generic/button/button.models';

@Component({
  selector: 'app-question-preview',
  templateUrl: './question-preview.component.html',
  styleUrls: ['./question-preview.component.scss']
})
export class QuestionPreviewComponent implements OnInit {
  canSetCorrectAnswer = this.questionFacade.currentQuestionOwnedByCurrentUser();
  question!: QuestionStateViewModel;
  working = true;
  ButtonType = ButtonType;
  constructor(
    private questionFacade: QuestionFacadeService,
    private notification: NotificationService,
    private dialog: SharedDialogService,
    public studentQuestion: StudentQuestionService
  ) {}

  ngOnInit(): void {
    this.questionFacade.getQuestion().subscribe((question) => {
      this.question = question;
      this.working = false;
    });

    this.questionFacade.effectWorking$.subscribe((effect) => {
      if (effect instanceof HttpErrorResponse) {
        this.notification.handleErrorsNotification(effect.error);
      }
    });
  }

  answerVoted(voteType: VoteType, answerUid: string, questionUid: string): void {
    this.questionFacade.voteAnswer(answerUid, questionUid, voteType);
  }

  setCorrectAnswer(questionUid: string, answerUid: string): void {
    this.questionFacade.setCorrectAnswer(questionUid, answerUid);
  }

  openRespondToAnswerDialog(answerUid: string): void {
    this.dialog.respondToAnswer(this.question.uid, answerUid);
  }

  editAnswer(questionUid: string, answerUid: string, text: string): void {
    this.dialog.editAnswer(questionUid, answerUid, text);
  }

  editAnswerResponse(questionUid: string, answerUid: string, answerResponseUid: string, text: string): void {
    this.dialog.editResponseToAnswer(questionUid, answerUid, answerResponseUid, text);
  }

  deleteAnswer(questionUid: string, answerUid: string): void {
    this.dialog.confirmDelete().subscribe((canDelete) => {
      if (canDelete) {
        this.questionFacade.deleteAnswer(answerUid, questionUid);
      }
    });
  }

  deleteAnswerResponse(questionUid: string, answerUid: string, answerResponseUid: string): void {
    this.dialog.confirmDelete().subscribe((canDelete) => {
      if (canDelete) {
        this.questionFacade.deleteAnswerResponse(answerUid, questionUid, answerResponseUid);
      }
    });
  }
}
