﻿using FinkiChattery.Api.ApplicationServices.Authentication;
using FinkiChattery.Api.ApplicationServices.Questioning;
using FinkiChattery.Commands.Questioning;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Contracts.Questioning;
using IdentityServer4.AccessTokenValidation;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Threading.Tasks;

namespace FinkiChattery.Api.Controllers.v1
{
    [ApiVersion(ApiVersions.ApiVersion1)]
    [Route("api/v{version:apiVersion}/questions/{questionUid:Guid}/answers/{answerUid:Guid}/[controller]")]
    [ApiController]
    public class AnswerResponsesController : ControllerBase
    {
        public AnswerResponsesController(IMediatorService mediatorService)
        {
            MediatorService = mediatorService;
        }

        public IMediatorService MediatorService { get; }

        [HttpPost]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> AddResponseToAnswer([FromRoute] Guid questionUid, [FromRoute] Guid answerUid, [FromBody] AnswerResponseRequest request)
        {
            var answerResponse = await MediatorService.SendAsync(new RespondToAnswerCommand(questionUid, answerUid, request.Text));
            return Ok(answerResponse.ToAnswerResponseQuestionStateResponse());
        }

        [HttpPut("{answerResponseUid:Guid}")]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> EditAnswerResponse([FromRoute] Guid questionUid, [FromRoute] Guid answerUid, [FromRoute] Guid answerResponseUid, [FromBody] AnswerResponseRequest request)
        {
            var answerResponse = await MediatorService.SendAsync(new EditAnswerResponseCommand(questionUid, answerUid, answerResponseUid, request.Text));
            return Ok(answerResponse.ToAnswerResponseQuestionStateResponse());
        }

        [HttpDelete("{answerResponseUid:Guid}")]
        [Authorize(AuthenticationSchemes = IdentityServerAuthenticationDefaults.AuthenticationScheme, Policy = AuthenticationPolicy.Student)]
        public async Task<IActionResult> DeleteAnswerResponse([FromRoute] Guid questionUid, [FromRoute] Guid answerUid, [FromRoute] Guid answerResponseUid)
        {
            var uid = await MediatorService.SendAsync(new DeleteAnswerResponseCommand(questionUid, answerUid, answerResponseUid));
            return Ok(uid);
        }
    }
}
