﻿using FinkiChattery.Common.Mediator.Contracs;
using FinkiChattery.Common.Mediator.Interfaces;
using FinkiChattery.Common.User;
using FinkiChattery.Persistence.UnitOfWork;
using System;
using System.Threading;
using System.Threading.Tasks;

namespace FinkiChattery.Commands.Questioning
{
    public class DeleteAnswerCommand : ICommand<Guid>
    {
        public DeleteAnswerCommand(Guid questionUid, Guid answerUid)
        {
            QuestionUid = questionUid;
            AnswerUid = answerUid;
        }

        public Guid QuestionUid { get; }
        public Guid AnswerUid { get; }
    }

    public class DeleteAnswerHandler : ICommandHandler<DeleteAnswerCommand, Guid>
    {
        public DeleteAnswerHandler(IUnitOfWork unitOfWork, ICurrentUser currentUser, IEventService eventService)
        {
            UnitOfWork = unitOfWork;
            CurrentUser = currentUser;
            EventService = eventService;
        }

        public IUnitOfWork UnitOfWork { get; }
        public ICurrentUser CurrentUser { get; }
        public IEventService EventService { get; }

        public async Task<Guid> Handle(DeleteAnswerCommand request, CancellationToken cancellationToken)
        {
            var answer = await UnitOfWork.Answers.GetByUidAsync(request.AnswerUid);

            UnitOfWork.Answers.Delete(answer);

            await UnitOfWork.SaveAsync();

            return answer.Uid;
        }
    }
}
